<?php
if (!defined('ABSPATH')) exit;

function shortcode_solicitudes_trabajador() {
    if (!is_user_logged_in()) {
        return '<p class="pure-alert">Debes iniciar sesión para acceder a esta sección.</p>';
    }

    global $wpdb;
    $user = wp_get_current_user();
    $user_id = $user->ID;

    // Obtener estado, rol y CIF del usuario
    $user_row = $wpdb->get_row($wpdb->prepare("SELECT user_estado, user_rol, user_cif FROM {$wpdb->prefix}users WHERE ID = %d", $user_id));
    if (!$user_row || $user_row->user_estado !== 'Activado') {
        return '<p class="pure-alert">No tienes permisos para acceder a esta sección.</p>';
    }

    $rol = $user_row->user_rol;
    $cif = $user_row->user_cif;
    $mensaje = '';

    if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['nueva_solicitud'])) {
        $tipo = sanitize_text_field($_POST['tipo']);
        $fecha_inicio = sanitize_text_field($_POST['fecha_inicio']);
        $fecha_fin = sanitize_text_field($_POST['fecha_fin']);
        $motivo = sanitize_textarea_field($_POST['motivo']);

        $wpdb->insert($wpdb->prefix . 'solicitudes', [
            'user_id' => $user_id,
            'cif_usuario' => $cif,
            'tipo' => $tipo,
            'fecha_inicio' => $fecha_inicio,
            'fecha_fin' => $fecha_fin,
            'motivo' => $motivo,
            'estado' => 'pendiente'
        ]);
$solicitud_id = $wpdb->insert_id;
        // Notificar al gestor
        $gestores = $wpdb->get_results($wpdb->prepare(
            "SELECT user_email, user_login FROM {$wpdb->prefix}users WHERE user_rol = 'Gestor' AND user_estado = 'Activado' AND user_cif = %s",
            $cif
        ));

        foreach ($gestores as $gestor) {
            enviar_correo_solicitud_permiso(
                $gestor->user_email,
                $user->display_name,
                $tipo,
                $fecha_inicio,
                $fecha_fin,
                $motivo,
                $solicitud_id 
            );
        }

        $mensaje = '<p style="color: green;">✅ Solicitud enviada correctamente.</p>';
    }

    // Mostrar solicitudes
   $condicion = $wpdb->prepare("user_id = %d", $user_id);


    $solicitudes = $wpdb->get_results("SELECT * FROM {$wpdb->prefix}solicitudes WHERE $condicion ORDER BY fecha_solicitud DESC");

    ob_start();
    if (isset($_GET['mensaje']) && $_GET['mensaje'] === 'resuelta') {
    echo '<div class="notice notice-success" style="margin-bottom:15px;padding:10px;background:#e0ffe0;border-left:4px solid green;">✅ Solicitud resuelta correctamente.</div>';
}

    ?>

    <h2 style="margin-bottom: 20px;">Solicitar vacaciones o permisos</h2>

    <?php echo $mensaje; ?>

    <form method="post" class="pure-form pure-form-stacked" style="max-width: 600px;">
        <fieldset>
            <label for="tipo">Tipo:</label>
            <select name="tipo" required>
                <option value="">-- Selecciona --</option>
                <option value="vacaciones">Vacaciones</option>
                <option value="permiso">Permiso</option>
            </select>

            <label for="fecha_inicio">Desde:</label>
            <input type="date" name="fecha_inicio" required>

            <label for="fecha_fin">Hasta:</label>
            <input type="date" name="fecha_fin" required>

            <label for="motivo">Motivo:</label>
            <textarea name="motivo" rows="3" style="width: 100%; resize: vertical;"></textarea>

            <button type="submit" name="nueva_solicitud" class="pure-button pure-button-primary" style="margin-top: 10px;">
                Enviar solicitud
            </button>
        </fieldset>
    </form>

    <h3 style="margin-top: 40px;">Solicitudes registradas</h3>

    <?php if ($solicitudes): ?>
        <table class="pure-table tabla-solicitudes" style="max-width: 900px;">
            <thead>
                <tr>
                    <th>Tipo</th>
                    <th>Desde</th>
                    <th>Hasta</th>
                    <th>Motivo</th>
                    <th>Estado</th>
                    <th>Fecha solicitud</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($solicitudes as $s): ?>
                    <tr>
                        <td><?php echo ucfirst($s->tipo); ?></td>
                        <td><?php echo date('d/m/Y', strtotime($s->fecha_inicio)); ?></td>
                        <td><?php echo date('d/m/Y', strtotime($s->fecha_fin)); ?></td>
                        <td><?php echo esc_html($s->motivo); ?></td>
                        <td><?php echo ucfirst($s->estado); ?></td>
                        <td><?php echo date('d/m/Y H:i', strtotime($s->fecha_solicitud)); ?></td>
                    </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    <?php else: ?>
        <p>No hay solicitudes registradas aún.</p>
    <?php endif; ?>

    <?php
    return ob_get_clean();
}
add_shortcode('solicitudes_trabajador', 'shortcode_solicitudes_trabajador');



add_action('admin_post_responder_solicitud', 'rh_responder_solicitud');
add_action('admin_post_nopriv_responder_solicitud', 'rh_responder_solicitud');

function rh_responder_solicitud() {
    if (!isset($_GET['id'], $_GET['respuesta'])) {
        wp_die('Faltan datos.');
    }

    global $wpdb;
    $id = intval($_GET['id']);
    $respuesta = sanitize_text_field($_GET['respuesta']);

   if (!in_array($respuesta, ['aprobado', 'rechazado'])) {
    wp_die('Respuesta inválida.');
}


    // Obtener solicitud
    $solicitud = $wpdb->get_row($wpdb->prepare("SELECT * FROM {$wpdb->prefix}solicitudes WHERE id = %d", $id));
    if (!$solicitud) {
        wp_die('Solicitud no encontrada.');
    }

    // Actualizar estado
    $wpdb->update(
        $wpdb->prefix . 'solicitudes',
        ['estado' => $respuesta],
        ['id' => $id]
    );

    // Obtener email del trabajador
    $trabajador = get_userdata($solicitud->user_id);
    if ($trabajador) {
        enviar_correo_respuesta_solicitud($trabajador->user_email, $respuesta, $solicitud);
    }

    $redirect_url = wp_get_referer() ?: home_url();
$redirect_url = add_query_arg('mensaje', 'resuelta', $redirect_url);
wp_redirect($redirect_url);
exit;

}


function enviar_correo_solicitud_permiso($email, $nombre_usuario, $tipo, $fecha_inicio, $fecha_fin, $motivo, $solicitud_id = null) {
    $template_path = plugin_dir_path(dirname(__FILE__)) . 'templates/solicitud-permiso.html';
    if (!file_exists($template_path)) return;

    $contenido = file_get_contents($template_path);

    $base_url = admin_url('admin-post.php');
    $aprobado_url = $base_url . "?action=responder_solicitud&id=$solicitud_id&respuesta=aprobada";
    $denegado_url = $base_url . "?action=responder_solicitud&id=$solicitud_id&respuesta=denegada";

    $placeholders = [
        '[user_name]' => $nombre_usuario,
        '[tipo]' => ucfirst($tipo),
        '[fecha_inicio]' => date('d/m/Y', strtotime($fecha_inicio)),
        '[fecha_fin]' => date('d/m/Y', strtotime($fecha_fin)),
        '[motivo]' => nl2br(esc_html($motivo)),
        '[aprobado_url]' => esc_url($aprobado_url),
        '[denegado_url]' => esc_url($denegado_url)
    ];

    $contenido_final = str_replace(array_keys($placeholders), array_values($placeholders), $contenido);

    $subject = "📩 Nueva solicitud de " . ucfirst($tipo) . " de $nombre_usuario";
    $headers = ['Content-Type: text/html; charset=UTF-8', 'From: E-Digitiall <no-reply@educasede.com>'];

    wp_mail($email, $subject, $contenido_final, $headers);
}


function enviar_correo_respuesta_solicitud($email, $respuesta, $solicitud) {
    $template_path = plugin_dir_path(dirname(__FILE__)) . 'templates/respuesta-solicitudes.html';

    if (!file_exists($template_path)) return;

    $contenido = file_get_contents($template_path);

    $placeholders = [
        '[estado]' => ucfirst($respuesta),
        '[tipo]' => ucfirst($solicitud->tipo),
        '[fecha_inicio]' => date('d/m/Y', strtotime($solicitud->fecha_inicio)),
        '[fecha_fin]' => date('d/m/Y', strtotime($solicitud->fecha_fin)),
        '[motivo]' => nl2br(esc_html($solicitud->motivo)),
    ];

    $contenido_final = str_replace(array_keys($placeholders), array_values($placeholders), $contenido);

    $subject = "📬 Solicitud " . ucfirst($solicitud->tipo) . " " . ucfirst($respuesta);
    $headers = ['Content-Type: text/html; charset=UTF-8', 'From: E-Digitiall <no-reply@educasede.com>'];

    wp_mail($email, $subject, $contenido_final, $headers);
} 