<?php
if (!defined('ABSPATH')) exit;

add_shortcode('revision_inspectores_lectura', 'revision_inspectores_lectura_shortcode');

function revision_inspectores_lectura_shortcode() {
   if (!is_user_logged_in()) return '';

    $user_id = get_current_user_id();
    $user_info = get_userdata($user_id);

    // Permitir solo roles Gestor y Trabajador
    if (!in_array('gestor', (array) $user_info->roles) && !in_array('trabajador', (array) $user_info->roles)) {
        return '<p class="pure-alert" style="text-align: center;">No has iniciado sesión.</p>';
    }

    global $wpdb;
    $user_id = get_current_user_id();

    $user_info = $wpdb->get_row($wpdb->prepare(
        "SELECT user_rol, user_estado FROM {$wpdb->prefix}users WHERE ID = %d",
        $user_id
    ));

    if (!$user_info || $user_info->user_rol !== 'Inspector' || $user_info->user_estado !== 'Activado') {
        return '<p class="pure-alert">No tienes permisos para acceder a esta sección.</p>';
    }

    $cif_registros = $wpdb->get_results($wpdb->prepare(
        "SELECT DISTINCT user_cif FROM {$wpdb->prefix}users 
 WHERE user_email = %s AND user_estado = 'Activado'",

        wp_get_current_user()->user_email
    ));
    $cifs = array_map(fn($r) => $r->user_cif, $cif_registros);

    if (isset($_POST['seleccionar_cif']) && in_array($_POST['cif'], $cifs)) {
        $_SESSION['cif_activo'] = sanitize_text_field($_POST['cif']);
    }
    $user_cif = $_SESSION['cif_activo'] ?? ($cifs[0] ?? null);

    if (!$user_cif || !in_array($user_cif, $cifs)) {
        return '<p class="pure-alert">No se pudo determinar un CIF activo válido.</p>';
    }

    $trabajadores = $wpdb->get_results($wpdb->prepare(
        "SELECT ID, display_name FROM {$wpdb->prefix}users 
         WHERE user_cif = %s AND user_rol IN ('Trabajador', 'Gestor')",
        $user_cif
    ));

    $trabajador_id = isset($_POST['trabajador_id']) ? intval($_POST['trabajador_id']) : '';
    $fecha_inicio = isset($_POST['fecha_inicio']) ? sanitize_text_field($_POST['fecha_inicio']) : '';
    $fecha_fin = isset($_POST['fecha_fin']) ? sanitize_text_field($_POST['fecha_fin']) : '';

    ob_start();
    ?>

    <h3>Revisión de Fichajes </h3>

    <form method="post" class="pure-form pure-form-stacked">
        <fieldset>
            <div style="display: flex; align-items: center; gap: 10px; flex-wrap: wrap;">
                <div>
                    <label>Desde:</label>
                    <input type="date" name="fecha_inicio" value="<?php echo esc_attr($fecha_inicio); ?>" required>
                </div>
                <div>
                    <label>Hasta:</label>
                    <input type="date" name="fecha_fin" value="<?php echo esc_attr($fecha_fin); ?>" required>
                </div>
                <?php if (count($cifs) > 1): ?>
                <div>
                    <label>Empresa:</label>
                    <select name="cif" onchange="this.form.submit()">
                        <?php foreach ($cifs as $cif): ?>
                            <option value="<?php echo esc_attr($cif); ?>" <?php selected($cif, $user_cif); ?>>
                                <?php echo esc_html($cif); ?>
                            </option>
                        <?php endforeach; ?>
                    </select>
                    <input type="hidden" name="seleccionar_cif" value="1">
                </div>
                <?php endif; ?>
                <div>
                    <label>Trabajador:</label>
                    <select name="trabajador_id" required>
                        <option value="">-- Seleccione --</option>
                        <?php foreach ($trabajadores as $t): ?>
                            <option value="<?php echo esc_attr($t->ID); ?>" <?php selected($trabajador_id, $t->ID); ?>>
                                <?php echo esc_html($t->display_name); ?>
                            </option>
                        <?php endforeach; ?>
                    </select>
                </div>
                <button type="submit" class="pure-button pure-button-primary">Consultar</button>
            </div>
        </fieldset>
    </form>

    <?php
    if (!empty($trabajador_id) && !empty($fecha_inicio) && !empty($fecha_fin)):
        $registros = $wpdb->get_results($wpdb->prepare(
            "SELECT entradaR, salidaR 
             FROM {$wpdb->prefix}registro_horario
             WHERE user_id = %d AND DATE(entradaR) BETWEEN %s AND %s
             ORDER BY entradaR ASC",
            $trabajador_id, $fecha_inicio, $fecha_fin
        ));

        $dias = [];
        $total_segundos_global = 0;

        foreach ($registros as $r) {
            if ($r->entradaR) {
                $fecha = date('Y-m-d', strtotime($r->entradaR));
                $dias[$fecha][] = $r;
                if ($r->salidaR) {
                    $inicio = strtotime($r->entradaR);
                    $fin = strtotime($r->salidaR);
                    if ($fin > $inicio) {
                        $total_segundos_global += $fin - $inicio;
                    }
                }
            }
        }

        $total_tiempo = sprintf('%02d:%02d:%02d',
            floor($total_segundos_global / 3600),
            floor(($total_segundos_global % 3600) / 60),
            $total_segundos_global % 60
        );
    ?>

    <div style="text-align: center; font-size: 20px; font-weight: bold; margin-top: 10px;">
        <p>Total: <?php echo esc_html($total_tiempo); ?></p>
    </div>

    <table class="pure-table pure-table-bordered" style="width: 100%; text-align: center;">
        <thead>
            <tr>
                <th>Día</th>
                <th>Entrada</th>
                <th>Salida</th>
                <th>Tiempo</th>
                <th>Total del Día</th>
            </tr>
        </thead>
        <tbody>
        <?php
        if ($dias) {
            $alternar = true;
            foreach ($dias as $fecha => $registros_dia) {
                $total_dia_seg = 0;
                foreach ($registros_dia as $r) {
                    if ($r->entradaR && $r->salidaR) {
                        $inicio = strtotime($r->entradaR);
                        $fin = strtotime($r->salidaR);
                        if ($fin > $inicio) {
                            $total_dia_seg += ($fin - $inicio);
                        }
                    }
                }

                $total_dia = sprintf('%02d:%02d:%02d',
                    floor($total_dia_seg / 3600),
                    floor(($total_dia_seg % 3600) / 60),
                    $total_dia_seg % 60
                );

                $rowspan = count($registros_dia);
                $fecha_formateada = date('d/m/Y', strtotime($fecha));
                $primero = true;
                $fondo = $alternar ? '#f9f9f9' : '#eeeeee';
                $alternar = !$alternar;

                foreach ($registros_dia as $r) {
                    $entrada = $r->entradaR ? date('H:i:s', strtotime($r->entradaR)) : '---';
                    $salida = $r->salidaR ? date('H:i:s', strtotime($r->salidaR)) : '---';

                    $tiempo = '---';
                    if ($r->entradaR && $r->salidaR) {
                        $seg = strtotime($r->salidaR) - strtotime($r->entradaR);
                        if ($seg > 0) {
                            $tiempo = sprintf('%02d:%02d:%02d', floor($seg / 3600), floor(($seg % 3600) / 60), $seg % 60);
                        }
                    }

                    echo "<tr style='background-color: $fondo;'>";
                    if ($primero) {
                        echo "<td rowspan='$rowspan'>$fecha_formateada</td>";
                    }
                    echo "<td>$entrada</td><td>$salida</td><td>$tiempo</td>";
                    if ($primero) {
                        echo "<td rowspan='$rowspan'>$total_dia</td>";
                        $primero = false;
                    }
                    echo "</tr>";
                }
            }
        } else {
            echo "<tr><td colspan='5'>No hay registros para este periodo.</td></tr>";
        }
        ?>
        </tbody>
    </table>

    <?php endif; ?>

    <?php
    return ob_get_clean();
}
?>
