<?php
// Evitar acceso directo
if (!defined('ABSPATH')) exit;

function qr_fichaje_shortcode() {
    $nonce = wp_create_nonce('qr_fichaje_nonce');
    $es_admin = current_user_can('administrator');

    ob_start();
    ?>
    <div style="display: flex; flex-direction: column; align-items: center; text-align: center; margin-top: 20px;">
        <button id="btnActivarCamara" class="pure-button pure-button-primary" 
                style="font-size: 18px; padding: 10px 20px; margin-bottom: 10px;">
            Activar Cámara
        </button>

        <?php if ($es_admin): ?>
            <button id="btnCambiarCamara" class="pure-button" 
                    style="font-size: 14px; padding: 6px 14px; margin-bottom: 10px; display: none;">
                Cambiar cámara
            </button>
        <?php endif; ?>

        <video id="preview" style="width: 300px; height: 250px; border: 2px solid #0078e7; border-radius: 10px; display: none;"></video>
        <p id="mensaje" style="margin-top: 10px; font-size: 16px; color: #0078e7;"></p>
    </div>

    <script>
    const ajaxurl = "<?php echo admin_url('admin-ajax.php'); ?>";
    const qrNonce = "<?php echo esc_js($nonce); ?>";
    const esAdmin = <?php echo $es_admin ? 'true' : 'false'; ?>;
    </script>

    <script src="https://cdnjs.cloudflare.com/ajax/libs/instascan/1.0.0/instascan.min.js"></script>
    <script>
    document.addEventListener("DOMContentLoaded", function() {
        let scanner = null;
        let cameras = [];
        let cameraIndex = 0;
        let isCameraActive = false;

        const btnCamara = document.getElementById("btnActivarCamara");
        const btnCambiar = document.getElementById("btnCambiarCamara");

        btnCamara.addEventListener("click", function() {
            if (!isCameraActive) iniciarCamara();
            else detenerCamara();
        });

        if (esAdmin && btnCambiar) {
            btnCambiar.addEventListener("click", () => {
                if (cameras.length > 1) {
                    cameraIndex = (cameraIndex + 1) % cameras.length;
                    scanner.start(cameras[cameraIndex]);
                }
            });
        }

        function iniciarCamara() {
            scanner = new Instascan.Scanner({ video: document.getElementById('preview'), mirror: true });
            scanner.addListener('scan', token => validarRegistroQR(token.trim()));

            Instascan.Camera.getCameras().then(function (cams) {
                if (cams.length > 0) {
                    cameras = cams;
                    scanner.start(cameras[cameraIndex]);
                    document.getElementById("preview").style.display = "block";
                    btnCamara.innerText = "Desactivar Cámara";
                    if (esAdmin && btnCambiar) btnCambiar.style.display = "inline-block";
                    isCameraActive = true;
                } else {
                    alert("No se encontró ninguna cámara en tu dispositivo.");
                }
            }).catch(e => console.error("Error al acceder a cámara:", e));
        }

        function detenerCamara() {
            if (scanner) scanner.stop();
            document.getElementById("preview").style.display = "none";
            btnCamara.innerText = "Activar Cámara";
            if (esAdmin && btnCambiar) btnCambiar.style.display = "none";
            isCameraActive = false;
        }

        function obtenerUbicacion(callback) {
            if (navigator.geolocation) {
                navigator.geolocation.getCurrentPosition(
                    pos => callback(pos.coords.latitude, pos.coords.longitude),
                    () => callback(null, null)
                );
            } else {
                callback(null, null);
            }
        }

        function validarRegistroQR(token) {
            fetch(ajaxurl, {
                method: 'POST',
                headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
                body: `action=validar_fichaje&dni=${token}&nonce=${qrNonce}`
            })
            .then(response => response.json())
            .then(data => {
                document.getElementById("mensaje").innerHTML = data.mensaje;
                if (data.registro_permitido) registrar(token, data.tipo);
            })
            .catch(error => console.error("Error validando:", error));
        }

        function registrar(token, tipo) {
            obtenerUbicacion((lat, lon) => {
                const body = `action=registrar_fichaje&dni=${token}&nonce=${qrNonce}` +
                             `&latitud=${lat ?? ''}&longitud=${lon ?? ''}`;

                fetch(ajaxurl, {
                    method: 'POST',
                    headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
                    body: body
                })
                .then(response => response.json())
                .then(data => {
                    document.getElementById("mensaje").innerHTML = data.mensaje;
                    setTimeout(() => location.reload(), 1000);
                });
            });
        }
    });
    </script>
    <?php
    return ob_get_clean();
}
add_shortcode('qr_fichaje', 'qr_fichaje_shortcode');
