<?php
if (!defined('ABSPATH')) exit;

function gestion_inspectores_shortcode() {
    global $wpdb;
    $tabla_usuarios = $wpdb->prefix . 'users';
    $tabla_usermeta = $wpdb->prefix . 'usermeta';
    $tabla_custom = $wpdb->prefix . 'users';

    $current_user_id = get_current_user_id();
    $current_user = $wpdb->get_row($wpdb->prepare("SELECT * FROM $tabla_custom WHERE ID = %d", $current_user_id));


// Obtener todos los CIFs activos del gestor
$cif_registros = $wpdb->get_results($wpdb->prepare(
    "SELECT DISTINCT user_cif FROM $tabla_custom 
     WHERE user_email = %s AND user_rol = 'Gestor' AND user_estado = 'Activado'",
    $current_user->user_email
));
$cifs = array_map(fn($r) => $r->user_cif, $cif_registros);

// CIF activo desde selector
if (isset($_POST['seleccionar_cif']) && in_array($_POST['cif'], $cifs)) {
    $_SESSION['cif_activo'] = sanitize_text_field($_POST['cif']);
}
$user_cif = $_SESSION['cif_activo'] ?? ($cifs[0] ?? null);

if (!$user_cif || !in_array($user_cif, $cifs)) {
    return '<p class="pure-alert">No se pudo determinar un CIF activo válido.</p>';
}

ob_start();
$current_user_id = get_current_user_id();
$current_user = get_userdata($current_user_id);

    if (!$current_user || $current_user->user_rol !== 'Gestor' || $current_user->user_estado !== 'Activado') {
        return '<p>No tienes permisos para ver esta página.</p>';
    }

    $mensaje = '';

    if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['guardar_inspector'])) {
    $user_id = isset($_POST['user_id']) ? intval($_POST['user_id']) : 0;
    $user_login = sanitize_text_field($_POST['user_login']);
    $user_email = sanitize_email($_POST['user_email']);
    $user_pass = wp_generate_password();
    $user_rol = 'Inspector';

    // Verificar duplicidad
    $condicion = $user_id ? "AND ID != %d" : "";
    $params = $user_id ? [$user_login, $user_email, $user_id] : [$user_login, $user_email];

    $existe = $wpdb->get_var($wpdb->prepare("
        SELECT COUNT(*) FROM $tabla_usuarios 
        WHERE (user_login = %s OR user_email = %s) $condicion
    ", ...$params));

    if ($existe > 0) {
        $mensaje = '<p style="color: red;">Ya existe un usuario con ese nombre de usuario o correo electrónico.</p>';
    } else {
        if ($user_id) {
            // Editar inspector
            $wpdb->update($tabla_usuarios, 
                [
                    'user_login'     => $user_login,
                    'user_email'     => $user_email,
                    'display_name'   => $user_login,
                    'user_nicename'  => $user_login
                ], 
                ['ID' => $user_id]
            );
                $mensaje = '<p style="color: green;">Inspector actualizado correctamente.</p>';
                wp_redirect(remove_query_arg(['nuevo_inspector', 'editar']));
                exit;
        } else {
            // Crear nuevo inspector
            $wpdb->insert($tabla_usuarios, [
                'user_login'      => $user_login,
                'user_email'      => $user_email,
                'user_pass'       => wp_hash_password($user_pass),
                'user_cif'        => $user_cif,
                'user_rol'        => $user_rol,
                'user_registered' => current_time('mysql'),
                'user_estado'     => 'Activado',
                'display_name'    => $user_login,
                'user_nicename'   => $user_login
            ]);

            // Enviar correo con las credenciales
            enviar_correo_bienvenida($user_email, $user_login, $user_pass);

            $mensaje = '<p style="color: green;">Inspector creado correctamente.</p>';
            wp_redirect(remove_query_arg(['nuevo_inspector', 'editar']));
            exit;
        }
    }
}


    if (isset($_GET['estado']) && isset($_GET['id'])) {
        $id = intval($_GET['id']);
        $nuevo_estado = $_GET['estado'] === 'Activar' ? 'Activado' : 'Desactivado';
        $wpdb->update($tabla_custom, ['user_estado' => $nuevo_estado], ['ID' => $id]);
        $mensaje = '<p style="color: blue;">Estado actualizado correctamente.</p>';
    }

    if (isset($_GET['reenviar'])) {
    $user_id = intval($_GET['reenviar']);
    $inspector = $wpdb->get_row($wpdb->prepare("SELECT * FROM $tabla_custom WHERE ID = %d", $user_id));

    if ($inspector) {
        $new_pass = wp_generate_password();
        $user_pass_hashed = wp_hash_password($new_pass);

        // Actualizar en ambas tablas con el mismo hash
        $wpdb->update($tabla_usuarios, ['user_pass' => $user_pass_hashed], ['ID' => $user_id]);
        $wpdb->update($tabla_custom,   ['user_pass' => $user_pass_hashed], ['ID' => $user_id]);

        enviar_correo_bienvenida($inspector->user_email, $inspector->user_login, $new_pass);
        $mensaje = '<p style="color: blue;">Contraseña reenviada correctamente.</p>';
    }
}


    $inspectores = $wpdb->get_results($wpdb->prepare("SELECT * FROM $tabla_custom WHERE user_rol = 'Inspector' AND user_cif = %s", $user_cif
));

    ob_start();
    ?>
    <link rel="stylesheet" href="https://unpkg.com/purecss@2.0.6/build/pure-min.css">

    <h3>Gestión de Inspectores</h3>
    <div style="display: flex; align-items: center; justify-content: space-between; margin-bottom: 20px; gap: 10px; flex-wrap: wrap;">
    <?php if (count($cifs) > 1): ?>
        <form method="post" class="pure-form" style="margin: 0;">
            <label for="cif">Empresa:</label>
            <select name="cif" onchange="this.form.submit()">
                <?php foreach ($cifs as $cif): ?>
                    <option value="<?php echo esc_attr($cif); ?>" <?php selected($cif, $user_cif); ?>>
                        <?php echo esc_html($cif); ?>
                    </option>
                <?php endforeach; ?>
            </select>
            <input type="hidden" name="seleccionar_cif" value="1">
        </form>
    <?php endif; ?>

    <a href="?nuevo_inspector=1" class="pure-button pure-button-primary">+ Añadir Inspector</a>
</div>



    <?php echo $mensaje; ?>

    <?php if (isset($_GET['nuevo_inspector']) || isset($_GET['editar'])):
        $editar = isset($_GET['editar']) ? intval($_GET['editar']) : 0;
        $inspector = $editar ? $wpdb->get_row($wpdb->prepare("SELECT * FROM $tabla_custom WHERE ID = %d", $editar)) : null;
    ?>
    <form method="post" class="pure-form pure-form-stacked" style="max-width: 400px; background: #f9f9f9; padding: 20px; border-radius: 10px;">
        <fieldset>
            <legend><?php echo $inspector ? 'Editar Inspector' : 'Nuevo Inspector'; ?></legend>
            <input type="hidden" name="user_id" value="<?php echo esc_attr($inspector ? $inspector->ID : ''); ?>">

            <label for="user_login">Nombre de Usuario</label>
            <input type="text" name="user_login" value="<?php echo esc_attr($inspector ? $inspector->user_login : ''); ?>" required>

            <label for="user_email">Correo Electrónico</label>
            <input type="email" name="user_email" value="<?php echo esc_attr($inspector ? $inspector->user_email : ''); ?>" required>

            <button type="submit" name="guardar_inspector" class="pure-button pure-button-primary">Guardar</button>
        </fieldset>
    </form>
    <?php endif; ?>

    <h3 style="margin-top: 40px;">Inspectores Registrados</h3>
    <table class="pure-table pure-table-striped" style="width: auto;">
        <thead>
            <tr>
                <th>Usuario</th>
                <th>Correo</th>
                <th>Último Acceso</th>
                <th>Estado</th>
                <th>Acciones</th>
            </tr>
        </thead>
        <tbody>
          <?php foreach ($inspectores as $insp): ?>
    <?php
        $estado = $insp->user_estado;

        $last_login_raw = get_user_meta($insp->ID, 'ultima_conexion_madrid', true);
        $last_login_fmt = 'No disponible';

        if (!empty($last_login_raw)) {
            $timestamp = strtotime($last_login_raw);
            if ($timestamp && $timestamp > 0) {
                $last_login_fmt = date('d/m/Y H:i', $timestamp);
            } else {
                $last_login_fmt = 'Formato inválido';
            }
        }

        // Estilo condicional para estado
        $estado_style = $estado === 'Activado'
            ? 'color: green; font-weight: bold;'
            : 'color: red; font-weight: bold;';
    ?>
    <tr>
        <td><?php echo esc_html($insp->user_login); ?></td>
        <td><?php echo esc_html($insp->user_email); ?></td>
        <td><?php echo esc_html($last_login_fmt); ?></td>
        <td style="<?php echo $estado_style; ?>"><?php echo esc_html($estado); ?></td>
        <td class="acciones">
  <div class="acciones">
    <a href="?editar=<?php echo $insp->ID; ?>" class="pure-button" title="Editar">✏️</a>
    <a href="?estado=<?php echo $estado === 'Activado' ? 'Desactivar' : 'Activar'; ?>&id=<?php echo $insp->ID; ?>" 
       class="pure-button" 
       title="<?php echo $estado === 'Activado' ? 'Desactivar' : 'Activar'; ?>">
      <?php echo $estado === 'Activado' ? '❌' : '✅'; ?>
    </a>
    <a href="?reenviar=<?php echo $insp->ID; ?>" class="pure-button" title="Reenviar contraseña">🔑</a>
  </div>
</td>

    </tr>
<?php endforeach; ?>


        </tbody>
    </table>
    <?php
    return ob_get_clean();
}
add_shortcode('gestion_inspectores', 'gestion_inspectores_shortcode');


// Función para enviar el correo de bienvenida
function enviar_correo_bienvenida($email, $nombre, $password) {
    $subject = "Bienvenido a E-Digitiall";

    // Ruta correcta a la plantilla HTML
    $template_path = plugin_dir_path(dirname(__FILE__)) . 'templates/email-nuevo-inspector.html';

    // Verificar que el archivo existe
    if (!file_exists($template_path)) {
        error_log("⚠️ No se encontró la plantilla de email en: $template_path");
        return;
    }

    // Cargar y preparar el contenido del HTML
    $message = file_get_contents($template_path);

    // Reemplazar los placeholders
    $message = str_replace(
        ['[user_login]', '[user_email]', '[password]'],
        [esc_html($nombre), esc_html($email), esc_html($password)],
        $message
    );

    // Cabeceras del email
    $headers = [
        'Content-Type: text/html; charset=UTF-8',
        'From: E-Digitiall <no-reply@educasede.com>'
    ];

    // Enviar el correo
    wp_mail($email, $subject, $message, $headers);
}


