<?php
// Evitar acceso directo
if (!defined('ABSPATH')) exit;

// Ya vienes con manage_options verificado en tu router de pestañas
global $wpdb;

// Tablas (ajusta si tus prefijos cambian)
$t_users = 'mnkt_users';
$t_emp   = 'mnkt_empresas';
$t_m2m   = 'mnkt_empresas_usuarios';

// ----- Acciones (POST) -----
$msg = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['asig_nonce']) && wp_verify_nonce($_POST['asig_nonce'], 'asig_action')) {
    $accion = isset($_POST['accion']) ? sanitize_text_field($_POST['accion']) : '';

    if ($accion === 'bulk_vincular') {
        $user_id = isset($_POST['user_id']) ? intval($_POST['user_id']) : 0;
        $empresas_ids = isset($_POST['empresas_ids']) && is_array($_POST['empresas_ids']) ? array_map('intval', $_POST['empresas_ids']) : [];

        if ($user_id > 0 && !empty($empresas_ids)) {
            $creados = 0; $saltados = 0;
            foreach ($empresas_ids as $empresa_id) {
                // Evitar duplicados: rol fijo Gestor, estado Activado
                $exists = $wpdb->get_var($wpdb->prepare(
                    "SELECT id FROM $t_m2m WHERE empresa_id=%d AND user_id=%d AND rol_en_empresa='Gestor' LIMIT 1",
                    $empresa_id, $user_id
                ));
                if ($exists) {
                    $saltados++;
                    continue;
                }
                $ok = $wpdb->insert($t_m2m, [
                    'empresa_id'     => $empresa_id,
                    'user_id'        => $user_id,
                    'rol_en_empresa' => 'Gestor',
                    'estado'         => 'Activado',
                    'creado_en'      => current_time('mysql'),
                ], ['%d','%d','%s','%s','%s']);
                if ($ok) $creados++; else $saltados++;
            }
            $msg = "✅ $creados vinculacione(s) creadas, ⚠️ $saltados saltada(s) (ya existían o fallaron).";
        } else {
            $msg = '⚠️ Selecciona un gestor y al menos una empresa.';
        }
    }

    if ($accion === 'eliminar') {
        $rel_id  = isset($_POST['rel_id']) ? intval($_POST['rel_id']) : 0;
        $user_id = isset($_POST['user_id']) ? intval($_POST['user_id']) : 0; // seguridad suave: borra solo si pertenece al gestor seleccionado
        if ($rel_id > 0 && $user_id > 0) {
            $del = $wpdb->query($wpdb->prepare("DELETE FROM $t_m2m WHERE id=%d AND user_id=%d", $rel_id, $user_id));
            $msg = $del ? '🗑️ Vinculación eliminada.' : '❌ No se pudo eliminar (o no pertenece al gestor seleccionado).';
        } else {
            $msg = '⚠️ Falta ID de vinculación/gestor.';
        }
    }
}

// ----- Filtros (GET) -----
$user_sel   = isset($_GET['user_id']) ? intval($_GET['user_id']) : 0;
$q_user     = isset($_GET['q_user']) ? sanitize_text_field($_GET['q_user']) : '';
$q_emp      = isset($_GET['q_emp']) ? sanitize_text_field($_GET['q_emp']) : '';
$solo_no_v  = isset($_GET['solo_no_v']) ? (int)$_GET['solo_no_v'] : 1; // por defecto, mostrar solo no vinculadas
$emp_count  = isset($_GET['emp_count']) ? intval($_GET['emp_count']) : 0;

// Gestores activados
$gestores_sql = "SELECT ID, display_name, user_email FROM $t_users WHERE user_estado='Activado' AND user_rol='Gestor'";
if ($q_user !== '') {
    $gestores_sql .= $wpdb->prepare(" AND (display_name LIKE %s OR user_email LIKE %s)", "%$q_user%", "%$q_user%");
}
$gestores_sql .= " ORDER BY display_name ASC LIMIT 300";
$gestores = $wpdb->get_results($gestores_sql);

// Empresas list (filtrable y, opcionalmente, solo no vinculadas con el gestor seleccionado)
$where = [];
$params = [];
if ($q_emp !== '') {
    $where[] = "(e.razon_social LIKE %s OR e.user_cif LIKE %s)";
    $params[] = "%$q_emp%";
    $params[] = "%$q_emp%";
}
$extra_not_exists = "";
if ($user_sel > 0 && $solo_no_v) {
    $extra_not_exists = " AND NOT EXISTS (SELECT 1 FROM $t_m2m eu WHERE eu.empresa_id = e.id AND eu.user_id = %d AND eu.rol_en_empresa='Gestor')";
    $params[] = $user_sel;
}
$emp_sql = "SELECT e.id, e.razon_social, e.user_cif FROM $t_emp e";
if (!empty($where)) $emp_sql .= " WHERE ".implode(" AND ", $where);
$emp_sql .= ($q_emp !== '' ? "" : " WHERE 1=1");
$emp_sql .= $extra_not_exists;
$emp_sql .= " ORDER BY e.razon_social ASC LIMIT 800";
$empresas = $wpdb->get_results($wpdb->prepare($emp_sql, ...$params));

/**
 * NUEVO: precargar gestores actuales por empresa (solo activos y rol Gestor)
 * para mostrarlos en el selector/listado de empresas.
 */
$gestores_por_empresa = [];
if (!empty($empresas)) {
    $ids_emp = array_map('intval', wp_list_pluck($empresas, 'id'));
    $ids_in  = implode(',', $ids_emp);
    // Ojo: solo construimos la consulta si hay IDs
    if ($ids_in !== '') {
        $sql_g = "
            SELECT eu.empresa_id, u.display_name
            FROM $t_m2m eu
            JOIN $t_users u ON u.ID = eu.user_id
            WHERE eu.empresa_id IN ($ids_in)
              AND eu.rol_en_empresa='Gestor'
              AND eu.estado='Activado'
            ORDER BY u.display_name
        ";
        $rows = $wpdb->get_results($sql_g);
        foreach ($rows as $row) {
            $gestores_por_empresa[(int)$row->empresa_id][] = $row->display_name;
        }
    }
}

// Vinculaciones actuales del gestor seleccionado (solo rol Gestor)
$vinc = [];
if ($user_sel > 0) {
    $vinc = $wpdb->get_results($wpdb->prepare("
        SELECT eu.id AS rel_id, e.id AS empresa_id, e.razon_social, e.user_cif, eu.estado, eu.creado_en
        FROM $t_m2m eu
        JOIN $t_emp e ON e.id = eu.empresa_id
        WHERE eu.user_id = %d AND eu.rol_en_empresa='Gestor'
        ORDER BY e.razon_social
    ", $user_sel));
}

// 👇 reemplaza el bloque de "Conteo de gestores por empresa" por esto
$emp_view = null;

if ($emp_count > 0) {
    // Empresa seleccionada
    $emp_row = $wpdb->get_row($wpdb->prepare("
        SELECT id, razon_social, user_cif
        FROM $t_emp
        WHERE id = %d
        LIMIT 1
    ", $emp_count));

    if ($emp_row) {
        // Gestores ACTIVOS vinculados (filtro en tabla de usuarios, no en M2M)
        $gestores_empresa = $wpdb->get_results($wpdb->prepare("
            SELECT u.ID, u.display_name, u.user_email
            FROM $t_m2m eu
            JOIN $t_users u ON u.ID = eu.user_id
            WHERE eu.empresa_id = %d
              AND u.user_rol = 'Gestor'
              AND u.user_estado = 'Activado'
            ORDER BY u.display_name ASC
        ", $emp_row->id));

        $emp_view = (object)[
            'empresa'  => $emp_row,
            'gestores' => $gestores_empresa,
        ];
    }
}

?>

<div class="wrap" style="max-width: 1100px;">
    <h2 style="margin-top:8px;">🗃️ Asignaciones rápidas (Gestor ⇄ Empresas)</h2>
    <p style="color:#666; margin-top:4px;">Flujo: selecciona un gestor activado, marca varias empresas y pulsa “Vincular”. Abajo ves sus empresas vinculadas y puedes borrarlas. A la derecha puedes consultar cuántos gestores tiene una empresa.</p>

    <?php if (!empty($msg)): ?>
        <div class="notice notice-info is-dismissible"><p><?php echo esc_html($msg); ?></p></div>
    <?php endif; ?>

    <div style="display:grid; grid-template-columns: 2fr 1fr; gap:18px;">
        <!-- Columna izquierda: Selección de gestor + listado de empresas -->
        <div class="postbox" style="padding:14px;">
            <h3 style="margin:0 0 10px;">1) Selecciona Gestor</h3>

            <form method="get" style="display:flex; gap:10px; align-items:flex-end; flex-wrap:wrap; margin-bottom:10px;">
                <input type="hidden" name="page" value="control-horario">
                <input type="hidden" name="tab" value="asignaciones">
                <div>
                    <label><strong>Buscar gestor</strong></label><br>
                    <input type="text" name="q_user" value="<?php echo esc_attr($q_user); ?>" placeholder="Nombre o email" style="min-width:280px;">
                    <button class="button">Buscar</button>
                </div>
                <div>
                    <label><strong>Gestor activado</strong></label><br>
                    <select name="user_id" onchange="this.form.submit()" style="min-width: 360px;">
                        <option value="0">— Selecciona gestor —</option>
                        <?php foreach ($gestores as $u): ?>
                            <option value="<?php echo esc_attr($u->ID); ?>" <?php selected($user_sel, $u->ID); ?>>
                                <?php echo esc_html($u->display_name ?: ('Usuario #'.$u->ID)); ?> — <?php echo esc_html($u->user_email); ?>
                            </option>
                        <?php endforeach; ?>
                    </select>
                </div>
            </form>

            <h3 style="margin:12px 0 10px;">2) Marcar empresas para vincular</h3>
            <form method="get" style="display:flex; gap:10px; align-items:flex-end; flex-wrap:wrap; margin-bottom:8px;">
                <input type="hidden" name="page" value="control-horario">
                <input type="hidden" name="tab" value="asignaciones">
                <input type="hidden" name="user_id" value="<?php echo esc_attr($user_sel); ?>">
                <div>
                    <label><strong>Buscar empresa</strong></label><br>
                    <input type="text" name="q_emp" value="<?php echo esc_attr($q_emp); ?>" placeholder="Razón social o CIF" style="min-width:280px;">
                    <button class="button">Buscar</button>
                </div>
                <label style="display:flex; gap:6px; align-items:center; margin-top: 6px;">
                    <input type="checkbox" name="solo_no_v" value="1" <?php checked($solo_no_v, 1); ?> onchange="this.form.submit()">
                    Mostrar solo no vinculadas
                </label>
            </form>

            <form method="post">
                <?php wp_nonce_field('asig_action','asig_nonce'); ?>
                <input type="hidden" name="accion" value="bulk_vincular">
                <input type="hidden" name="user_id" value="<?php echo esc_attr($user_sel); ?>">

                <?php if ($user_sel === 0): ?>
                <?php else: ?>
                    <?php if (empty($empresas)): ?>
                        <div class="notice notice-info"><p>No hay empresas para mostrar con el filtro actual.</p></div>
                    <?php else: ?>
                        <div style="max-height: 360px; overflow: auto; border:1px solid #e5e5e5; padding:8px; border-radius:6px;">
                            <table class="widefat striped">
                                <thead>
                                    <tr>
                                        <th style="width:40px;"><input type="checkbox" onclick="jQuery('.chk-empresa').prop('checked', this.checked)"></th>
                                        <th>Empresa</th>
                                        <th>CIF</th>
                                        <th>Gestores actuales (activos)</th> <!-- NUEVA COLUMNA -->
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php foreach ($empresas as $e): 
                                        $gestores_txt = '';
                                        if (!empty($gestores_por_empresa[(int)$e->id])) {
                                            // Lista de nombres; si hay muchos puedes limitar
                                            $nombres = $gestores_por_empresa[(int)$e->id];
                                            // Opcional: limitar a 5 y añadir "+N"
                                            if (count($nombres) > 5) {
                                                $extra = count($nombres) - 5;
                                                $nombres = array_slice($nombres, 0, 5);
                                                $gestores_txt = esc_html(implode(', ', $nombres)) . " +$extra";
                                            } else {
                                                $gestores_txt = esc_html(implode(', ', $nombres));
                                            }
                                        } else {
                                            $gestores_txt = '—';
                                        }
                                    ?>
                                        <tr>
                                            <td><input class="chk-empresa" type="checkbox" name="empresas_ids[]" value="<?php echo esc_attr($e->id); ?>"></td>
                                            <td><?php echo esc_html($e->razon_social ?: ('Empresa #'.$e->id)); ?> (ID <?php echo esc_html($e->id); ?>)</td>
                                            <td><?php echo esc_html($e->user_cif); ?></td>
                                            <td><?php echo $gestores_txt; ?></td>
                                        </tr>
                                    <?php endforeach; ?>
                                </tbody>
                            </table>
                        </div>
                        <div style="margin-top:10px;">
                            <button type="submit" class="button button-primary">Vincular seleccionadas como Gestor</button>
                        </div>
                    <?php endif; ?>
                <?php endif; ?>
            </form>

            <h3 style="margin:16px 0 8px;">3) Empresas ya vinculadas a este gestor</h3>
            <?php if ($user_sel === 0): ?>
            <?php elseif (empty($vinc)): ?>
                <div class="notice notice-info"><p>Este gestor no tiene empresas vinculadas todavía.</p></div>
            <?php else: ?>
                <table class="widefat fixed striped">
                    <thead>
                        <tr>
                            <th>Empresa</th>
                            <th>CIF</th>
                            <th>Estado</th>
                            <th>Creado</th>
                            <th style="width:120px;">Acciones</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($vinc as $r): ?>
                            <tr>
                                <td><?php echo esc_html($r->razon_social ?: 'Empresa #'.$r->empresa_id); ?> (ID <?php echo esc_html($r->empresa_id); ?>)</td>
                                <td><?php echo esc_html($r->user_cif); ?></td>
                                <td><?php echo esc_html($r->estado); ?></td>
                                <td><?php echo esc_html($r->creado_en); ?></td>
                                <td>
                                    <form method="post" onsubmit="return confirm('¿Eliminar esta vinculación?');" style="display:inline;">
                                        <?php wp_nonce_field('asig_action','asig_nonce'); ?>
                                        <input type="hidden" name="accion" value="eliminar">
                                        <input type="hidden" name="rel_id" value="<?php echo esc_attr($r->rel_id); ?>">
                                        <input type="hidden" name="user_id" value="<?php echo esc_attr($user_sel); ?>">
                                        <button class="button button-small">Eliminar</button>
                                    </form>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            <?php endif; ?>
        </div>

        <!-- Columna derecha: Consulta de gestores por empresa -->
        <div class="postbox" style="padding:14px;">
            <h3 style="margin:0 0 10px;">Consulta: gestores por empresa</h3>
            <form method="get" style="display:flex; gap:10px; align-items:flex-end; flex-wrap:wrap; margin-bottom:10px;">
                <input type="hidden" name="page" value="control-horario">
                <input type="hidden" name="tab" value="asignaciones">
                <input type="hidden" name="user_id" value="<?php echo esc_attr($user_sel); ?>">
                <div>
                    <label><strong>Empresa</strong></label><br>
                    <select name="emp_count" style="min-width: 320px;">
                        <option value="0">— Selecciona empresa —</option>
                        <?php
                        // Listado completo para el combo de consulta
                        $emp_all = $wpdb->get_results("SELECT id, razon_social, user_cif FROM $t_emp ORDER BY razon_social ASC LIMIT 800");
                        foreach ($emp_all as $e) : ?>
                            <option value="<?php echo esc_attr($e->id); ?>" <?php selected($emp_count, $e->id); ?>>
                                <?php echo esc_html($e->razon_social ?: ('Empresa #'.$e->id)); ?> — <?php echo esc_html($e->user_cif); ?>
                            </option>
                        <?php endforeach; ?>
                    </select>
                </div>
                <button class="button">Ver</button>
            </form>

            <?php if ($emp_view): ?>
    <div style="padding:10px; border:1px solid #e5e5e5; border-radius:6px; background:#fafafa;">
        <div>
            <strong><?php echo esc_html($emp_view->empresa->razon_social ?: 'Empresa #'.$emp_view->empresa->id); ?></strong>
            — CIF: <?php echo esc_html($emp_view->empresa->user_cif); ?>
        </div>

        <?php if (empty($emp_view->gestores)): ?>
            <p style="margin:10px 0 0; color:#666;">No hay gestores activos vinculados.</p>
        <?php else: ?>
            <table class="widefat striped" style="margin-top:10px;">
                <thead>
                    <tr>
                        <th style="width:80px;">ID</th>
                        <th>Nombre</th>
                        <th>Email</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($emp_view->gestores as $g): ?>
                        <tr>
                            <td><?php echo esc_html($g->ID); ?></td>
                            <td><?php echo esc_html($g->display_name ?: '—'); ?></td>
                            <td><?php echo esc_html($g->user_email ?: '—'); ?></td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        <?php endif; ?>
    </div>
<?php else: ?>
    <p style="color:#666;">Selecciona una empresa y pulsa “Ver”.</p>
<?php endif; ?>

        </div>
    </div>
</div>
