<?php
/*
Plugin Name: Acceso Dispositivo Único
Description: Restringe acceso a una página solo al primer dispositivo que la visite.
Version: 1.0
Author: Tu Nombre
*/


/* ARCHIVO COMENTADO


defined('ABSPATH') || exit;

// SHORTCODE
add_shortcode('acceso_dispositivo_unico', function($atts, $content = null) {
    ob_start();

    // ADMIN: panel y reset
    if (current_user_can('manage_options')) {
        if (isset($_POST['reset_device_id'])) {
            delete_option('adu_device_id');
            echo '<div style="color:green;"><strong>✅ Dispositivo autorizado reseteado.</strong></div>';
        }

        $current_id = get_option('adu_device_id');
        echo '<div style="border:1px solid #ccc;padding:10px;margin:15px 0;">';
        echo '<strong>Device ID actual:</strong> <code>' . esc_html($current_id ?: 'Ninguno') . '</code>';
        echo '<form method="post" style="margin-top:10px;"><input type="submit" name="reset_device_id" value="🔁 Resetear dispositivo autorizado"></form>';
        echo '</div>';
    }

    // Zona protegida
    ?>
    <div id="contenido-autorizado" style="display:none;"><?php echo do_shortcode($content); ?></div>
    <div id="acceso-denegado" style="display:none;"><strong>⛔ Acceso denegado.</strong></div>

    <script>
    (function(){
        const endpoint = "<?php echo esc_url(rest_url('adu/v1/verificar')); ?>";
        let deviceId = localStorage.getItem("device_id");

        async function verificar(id) {
            const res = await fetch(endpoint + "?id=" + encodeURIComponent(id));
            const data = await res.json();
            if (data.autorizado) {
                document.getElementById("contenido-autorizado").style.display = "block";
            } else {
                document.getElementById("acceso-denegado").style.display = "block";
            }
        }

        if (deviceId) {
            verificar(deviceId);
        } else {
            deviceId = crypto.randomUUID();
            localStorage.setItem("device_id", deviceId);

            fetch(endpoint, {
                method: "POST",
                headers: { "Content-Type": "application/json" },
                body: JSON.stringify({ id: deviceId })
            }).then(() => verificar(deviceId));
        }
    })();
    </script>
    <?php
    return ob_get_clean();
});

// REST API
add_action('rest_api_init', function () {
    register_rest_route('adu/v1', '/verificar', [
        'methods' => ['GET', 'POST'],
        'callback' => 'adu_verificar_dispositivo',
        'permission_callback' => '__return_true',
    ]);
});

function adu_verificar_dispositivo($request) {
    $body_raw = $request->get_body();
    $body = json_decode($body_raw, true);
    $id = isset($body['id']) ? sanitize_text_field($body['id']) : sanitize_text_field($request->get_param('id'));
    $stored = get_option('adu_device_id');

    error_log('[ADU] Método: ' . $request->get_method());
    error_log('[ADU] ID recibido: ' . $id);
    error_log('[ADU] ID guardado: ' . $stored);

    if ($request->get_method() === 'POST') {
        if (empty($stored)) {
            update_option('adu_device_id', $id);
            error_log('[ADU] Nuevo dispositivo registrado: ' . $id);
            return ['status' => 'registrado'];
        } else {
            return ['status' => 'ya_registrado'];
        }
    }

    return ['autorizado' => ($id === $stored)];
}
*/