<?php


add_shortcode('datos_cuenta', 'mostrar_datos_usuario_mnkt');

function mostrar_datos_usuario_mnkt() {
    global $wpdb;

    $current_user_id = get_current_user_id();
    if (!$current_user_id) {
        return '<p class="alert alert-danger">Debes iniciar sesión para ver esta información.</p>';
    }

    $user_data = get_userdata($current_user_id);
    $user_login = $user_data ? $user_data->user_login : null;
    if (!$user_login) {
        return '<p class="alert alert-danger">No se pudo obtener tu login de usuario.</p>';
    }

    $tabla_usuarios = 'mnkt_users';
    $tabla_empresas = $wpdb->prefix . 'empresas';

    $usuario = $wpdb->get_row($wpdb->prepare(
        "SELECT * FROM $tabla_usuarios WHERE TRIM(LOWER(user_login)) = TRIM(LOWER(%s))",
        $user_login
    ));

    if (!$usuario) {
        return '<p class="alert alert-danger">No se encontraron datos en mnkt_users para tu cuenta.</p>';
    }

    if (strtolower($usuario->user_rol) !== 'gestor' || strtolower($usuario->user_estado) !== 'activado') {
        return '<p class="alert alert-danger">Tu cuenta no está activa o no tienes el rol adecuado.</p>';
    }

    // Calcular días desde registro
    $fecha_registro = new DateTime($usuario->user_registered);
    $fecha_limite_prueba = (clone $fecha_registro)->modify('+30 days');
    $fecha_limite_documentacion = (clone $fecha_limite_prueba)->modify('+10 days');
    $hoy = new DateTime();

    $dias_restantes = $hoy < $fecha_limite_prueba ? $hoy->diff($fecha_limite_prueba)->days : 0;
    $en_prueba = $hoy < $fecha_limite_prueba;
    $en_validacion = !$en_prueba && $hoy < $fecha_limite_documentacion;
    $bloquear_acceso = !$en_prueba && !$en_validacion;

    // Gamificación
    $gamificacion = (int) $usuario->user_gamificacion === 1
        ? '<span style="color: green; font-weight: bold;">Activado</span>'
        : '<span style="color: red; font-weight: bold;">Desactivado</span>';

    // Obtener empresas asociadas
    $empresas = $wpdb->get_results($wpdb->prepare(
        "SELECT * FROM $tabla_empresas WHERE user_id = %d",
        $current_user_id
    ));

    ob_start();
    ?>
    <div class="container-plugin">
        <h3>🕒 Tiempo restante hasta fin de la prueba gratuita</h3>

        <?php if ($en_prueba): ?>
            <div class="alert alert-success" style="font-size: 18px; text-align: center;">
                <?php echo $dias_restantes; ?> días restantes
            </div>
        <?php elseif ($en_validacion): ?>
            <div class="alert alert-warning" style="font-size: 18px; text-align: center;">
                Estás en el periodo de validación documental. Por favor completa la firma y selecciona método de pago.
            </div>
        <?php else: ?>
            <div class="alert alert-danger" style="font-size: 18px; text-align: center;">
                Tu periodo ha finalizado. Es necesario completar documentación y pago para continuar.
            </div>
        <?php endif; ?>

        <div class="user-data">
            <ul>
                <li><strong>Usuario:</strong> <?php echo esc_html($usuario->user_login); ?></li>
                <li><strong>Email:</strong> <?php echo esc_html($usuario->user_email); ?></li>
                <li><strong>Fecha de Registro:</strong> <?php echo esc_html($usuario->user_registered); ?></li>
                <li><strong>Estado:</strong> <?php echo esc_html($usuario->user_estado); ?></li>
                <li><strong>Gamificación:</strong> <?php echo $gamificacion; ?></li>
            </ul>
        </div>

        <?php if ($empresas): ?>
            <h3>🏢 Estado documental por empresa</h3>
            <table class="pure-table pure-table-bordered">
                <thead>
                    <tr>
                        <th>CIF</th>
                        <th>Razón Social</th>
                        <th>RGPD</th>
                        <th>SEPA</th>
                        <th>Método Pago</th>
                        <th>Estado</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($empresas as $empresa): ?>
                        <tr>
                            <td><?php echo esc_html($empresa->user_cif); ?></td>
                            <td><?php echo esc_html($empresa->razon_social); ?></td>
                            <td style="color: <?php echo $empresa->aceptacion_proteccion_datos ? 'green' : 'red'; ?>; font-weight: bold;">
                                <?php echo $empresa->aceptacion_proteccion_datos ? 'Sí' : 'No'; ?>
                            </td>
                            <td style="color: <?php echo $empresa->aceptacion_sepa ? 'green' : 'red'; ?>; font-weight: bold;">
                                <?php echo $empresa->aceptacion_sepa ? 'Sí' : 'No'; ?>
                            </td>
                            <td><?php echo esc_html($empresa->metodo_pago); ?></td>
                            <td><?php echo esc_html($empresa->estado_validacion); ?></td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        <?php else: ?>
            <p class="alert alert-warning">No tienes empresas registradas aún.</p>
        <?php endif; ?>
    </div>
    <?php
    return ob_get_clean();
}


///////////////////documentación 

add_shortcode('documentacion_usuario', 'mnkt_shortcode_documentacion_usuario');

function mnkt_shortcode_documentacion_usuario() {
    global $wpdb;

    $user_id = get_current_user_id();
    if (!$user_id) {
        return '<p class="alert alert-danger">Debes iniciar sesión para acceder a tu documentación.</p>';
    }

    $tabla_empresas = $wpdb->prefix . 'empresas';

    // Obtener todas las empresas (CIFs) del usuario
    $cifs = $wpdb->get_results($wpdb->prepare(
        "SELECT * FROM $tabla_empresas WHERE user_id = %d",
        $user_id
    ));

    if (empty($cifs)) {
        return '<p class="alert alert-warning">No tienes CIFs registrados todavía.</p>';
    }

    // Determinar CIF seleccionado
    $cif_url = isset($_GET['cif']) ? sanitize_text_field($_GET['cif']) : null;
    $cif_post = isset($_POST['cif_seleccionado']) ? sanitize_text_field($_POST['cif_seleccionado']) : null;

    $cif_seleccionado = $cif_post ?: $cif_url;

    // Validar que el CIF seleccionado pertenece al usuario
    $empresa_seleccionada = null;
    foreach ($cifs as $empresa) {
        if ($empresa->user_cif === $cif_seleccionado) {
            $empresa_seleccionada = $empresa;
            break;
        }
    }

    // Si no se encontró o no se especificó, usar el primero
    if (!$empresa_seleccionada) {
        $empresa_seleccionada = $cifs[0];
        $cif_seleccionado = $empresa_seleccionada->user_cif;
    }

    // Procesar el formulario
    if (isset($_POST['guardar_documentacion'])) {
        $acepta_rgpd = isset($_POST['aceptacion_proteccion_datos']) ? 1 : 0;
        $acepta_sepa = isset($_POST['aceptacion_sepa']) ? 1 : 0;
        $metodo_pago = sanitize_text_field($_POST['metodo_pago']);

        // Guardar los datos
        $wpdb->update(
            $tabla_empresas,
            [
                'aceptacion_proteccion_datos' => $acepta_rgpd,
                'aceptacion_sepa' => $acepta_sepa,
                'metodo_pago' => $metodo_pago,
                'fecha_aceptacion' => current_time('mysql'),
                'ip_firma' => $_SERVER['REMOTE_ADDR'],
                'user_agent' => $_SERVER['HTTP_USER_AGENT'],
                'estado_validacion' => ($acepta_rgpd && $acepta_sepa && $metodo_pago) ? 'Validado' : 'Pendiente'
            ],
            [
                'user_id' => $user_id,
                'user_cif' => $cif_seleccionado
            ]
        );

        // Refrescar datos
        $empresa_seleccionada = $wpdb->get_row($wpdb->prepare(
            "SELECT * FROM $tabla_empresas WHERE user_id = %d AND user_cif = %s",
            $user_id,
            $cif_seleccionado
        ));
    }

    ob_start();
    ?>
    <div class="container-plugin">
        <h3>📄 Documentación Legal para el CIF: <?php echo esc_html($empresa_seleccionada->user_cif); ?></h3>

        <form method="post" class="pure-form pure-form-stacked">
            <label for="cif_seleccionado">Seleccionar CIF:</label>
            <select name="cif_seleccionado" onchange="this.form.submit()" class="pure-input-1">
                <?php foreach ($cifs as $empresa): ?>
                    <option value="<?php echo esc_attr($empresa->user_cif); ?>" <?php selected($empresa->user_cif, $cif_seleccionado); ?>>
                        <?php echo esc_html($empresa->user_cif . ' - ' . $empresa->razon_social); ?>
                    </option>
                <?php endforeach; ?>
            </select>

            <fieldset>
                <legend>Documentación a firmar</legend>
                <label>
                    <input type="checkbox" name="aceptacion_proteccion_datos" value="1" <?php checked($empresa_seleccionada->aceptacion_proteccion_datos, 1); ?> />
                    Acepto la Política de Protección de Datos
                </label>
                <label>
                    <input type="checkbox" name="aceptacion_sepa" value="1" <?php checked($empresa_seleccionada->aceptacion_sepa, 1); ?> />
                    Acepto la Normativa SEPA
                </label>
            </fieldset>

            <fieldset>
                <legend>Método de pago</legend>
                <?php
                $metodos = ['Domiciliación', 'Tarjeta', 'Transferencia'];
                foreach ($metodos as $metodo) {
                    echo '<label><input type="radio" name="metodo_pago" value="' . esc_attr($metodo) . '" ' . checked($empresa_seleccionada->metodo_pago, $metodo, false) . '> ' . esc_html($metodo) . '</label><br>';
                }
                ?>
            </fieldset>

            <button type="submit" name="guardar_documentacion" class="pure-button pure-button-primary">Guardar Información</button>
        </form>

        <div class="alert alert-<?php echo ($empresa_seleccionada->estado_validacion === 'Validado') ? 'success' : 'warning'; ?>" style="margin-top:20px;">
            Estado actual de la documentación: <strong><?php echo esc_html($empresa_seleccionada->estado_validacion); ?></strong>
        </div>
        <?php if ($empresa_seleccionada->aceptacion_sepa && $empresa_seleccionada->metodo_pago): ?>
    <a href="<?php echo esc_url(admin_url('admin-post.php?action=generar_pdf_sepa&cif=' . urlencode($empresa_seleccionada->user_cif))); ?>"
       class="pure-button pure-button-secondary" target="_blank" style="margin-top: 15px; display: inline-block;">
        📄 Descargar Mandato SEPA
    </a>
<?php endif; ?>

    </div>
    <?php
    return ob_get_clean();
}
