<?php
if (!defined('ABSPATH')) exit;

/**
 * Dashboard CH Stripe (escritorio principal)
 */
function ch_render_ch_stripe_dashboard() {
    if (!current_user_can('manage_options')) wp_die('No permitido');
    global $wpdb;

    $t_emp = 'mnkt_empresas';

    // --- Conteo por método de pago ---
    $by_method = $wpdb->get_results("
        SELECT metodo_pago, COUNT(*) c
        FROM {$t_emp}
        GROUP BY metodo_pago
    ", OBJECT_K);

    $count_tarjeta        = isset($by_method['Tarjeta'])        ? intval($by_method['Tarjeta']->c)        : 0;
    $count_domiciliacion  = isset($by_method['Domiciliación'])  ? intval($by_method['Domiciliación']->c)  : 0;
    $count_transferencia  = isset($by_method['Transferencia'])  ? intval($by_method['Transferencia']->c)  : 0;
    $count_vacio          = isset($by_method[''])               ? intval($by_method['']->c)               : 0;

    // --- Trial en curso (TOTAL) ---
    $trial_total = (int)$wpdb->get_var("
        SELECT COUNT(*) FROM {$t_emp}
        WHERE trial_status='en_curso'
    ");

    // --- Trials que vencen pronto (≤10 y ≤30 días) ---
    $exp_10 = (int)$wpdb->get_var("
        SELECT COUNT(*) FROM {$t_emp}
        WHERE trial_status='en_curso'
          AND trial_expires_at IS NOT NULL
          AND DATEDIFF(trial_expires_at, UTC_TIMESTAMP()) BETWEEN 0 AND 10
    ");

    $exp_30 = (int)$wpdb->get_var("
        SELECT COUNT(*) FROM {$t_emp}
        WHERE trial_status='en_curso'
          AND trial_expires_at IS NOT NULL
          AND DATEDIFF(trial_expires_at, UTC_TIMESTAMP()) BETWEEN 0 AND 30
    ");

    // --- Con suscripción activa (según BD) ---
    $with_active_sub = (int)$wpdb->get_var("
        SELECT COUNT(*) FROM {$t_emp}
        WHERE (stripe_subscription_id IS NOT NULL AND stripe_subscription_id <> '')
          AND (estado_empresa='activado' OR trial_status='convertido')
    ");

    // --- Total empresas ---
    $total_empresas = (int)$wpdb->get_var("SELECT COUNT(*) FROM {$t_emp}");

    // --- Previsión de ingresos próximo mes (Stripe, planes mensuales) ---
    $forecast_eur   = null;
    $stripe_count_active = null;

    $secret = defined('CONTROL_HORARIO_STRIPE_SECRET_KEY')
        ? CONTROL_HORARIO_STRIPE_SECRET_KEY
        : get_option('ch_stripe_secret_key', '');

    $sdk = (defined('CH_STRIPE_WH_PLUGIN_DIR') ? CH_STRIPE_WH_PLUGIN_DIR : trailingslashit(dirname(__DIR__))) . 'lib/stripe-php/init.php';
    if ($secret && file_exists($sdk)) {
        require_once $sdk;
        if (class_exists('\Stripe\StripeClient')) {
            try {
                $client = new \Stripe\StripeClient($secret);
                $params = ['status' => 'active', 'limit'  => 100];
                $has_more = true; $starting_after = null;
                $sum_cents = 0; $active_counter = 0;

                while ($has_more) {
                    if ($starting_after) $params['starting_after'] = $starting_after;
                    $subs = $client->subscriptions->all($params);
                    foreach ($subs->data as $sub) {
                        $active_counter++;
                        foreach ($sub->items->data ?? [] as $it) {
                            $plan = $it->plan ?? null;
                            if ($plan && ($plan->interval ?? '') === 'month') {
                                $amount = (int)($plan->amount ?? 0);
                                $qty    = max(1, (int)($it->quantity ?? 1));
                                $sum_cents += $amount * $qty;
                            }
                        }
                    }
                    $has_more = !empty($subs->has_more);
                    if ($has_more) {
                        $last = end($subs->data);
                        $starting_after = $last ? $last->id : null;
                    }
                }
                $forecast_eur        = round($sum_cents / 100, 2);
                $stripe_count_active = $active_counter;
            } catch (\Throwable $e) { /* silencioso */ }
        }
    }

    // Helper para tarjeta KPI
    $kpi = function($label, $value, $sub = '') {
        ?>
        <div style="flex:1;min-width:200px;background:#fff;border:1px solid #e5e7eb;border-radius:10px;padding:16px 18px;box-shadow:0 2px 10px rgba(0,0,0,.03);">
            <div style="font-size:12px;color:#6b7280;margin-bottom:6px;"><?php echo esc_html($label); ?></div>
            <div style="font-size:28px;font-weight:800;line-height:1;color:#111827;"><?php echo esc_html($value); ?></div>
            <?php if ($sub): ?><div style="font-size:12px;color:#6b7280;margin-top:6px;"><?php echo wp_kses_post($sub); ?></div><?php endif; ?>
        </div>
        <?php
    };

    ?>
    <div class="wrap">
        <h1>Dashboard CH Stripe</h1>
        <p style="color:#4b5563;margin-top:4px;">Resumen rápido de empresas y previsión. Datos en tiempo real desde tu base de datos y (opcionalmente) Stripe.</p>

        <div style="display:flex;gap:12px;flex-wrap:wrap;margin-top:16px;">
            <?php
            $kpi('Total empresas', $total_empresas);
            $kpi('Trial en curso (total)', $trial_total);
            $kpi('Pago por Tarjeta', $count_tarjeta);
            $kpi('Domiciliación', $count_domiciliacion);
            $kpi('Transferencia', $count_transferencia);
            ?>
        </div>

        <div style="display:flex;gap:12px;flex-wrap:wrap;margin-top:12px;">
            <?php
            $kpi('Trial: vence ≤ 10 días', $exp_10);
            $kpi('Trial: vence ≤ 30 días', $exp_30);
            $kpi('Con suscripción activa (BD)', $with_active_sub);
            ?>
        </div>

        <div style="display:flex;gap:12px;flex-wrap:wrap;margin-top:12px;">
            <?php
            if ($forecast_eur !== null) {
                $kpi('Previsión ingresos próximo mes', number_format($forecast_eur, 2, ',', '.') . ' €',
                    $stripe_count_active !== null ? 'Subs activas (Stripe): <strong>'.$stripe_count_active.'</strong>' : ''
                );
            } else {
                $kpi('Previsión ingresos próximo mes', '—', 'Configura la clave secreta de Stripe para ver esta métrica.');
            }
            ?>
        </div>

        <hr style="margin:24px 0;" />

        <h2 style="margin:0 0 8px;">Filtros rápidos</h2>
        <p style="margin-top:0;color:#6b7280;">Accesos a la vista de Suscripciones con filtros aplicados.</p>
        <p>
            <a class="button" href="<?php echo esc_url( add_query_arg(['page'=>'ch-suscripciones-stripe','s'=>'','metodo'=>'Tarjeta'], admin_url('admin.php')) ); ?>">Solo Tarjeta</a>
            <a class="button" href="<?php echo esc_url( add_query_arg(['page'=>'ch-suscripciones-stripe','exp'=>'10'], admin_url('admin.php')) ); ?>">Trial ≤ 10 días</a>
            <a class="button" href="<?php echo esc_url( add_query_arg(['page'=>'ch-suscripciones-stripe','exp'=>'30'], admin_url('admin.php')) ); ?>">Trial ≤ 30 días</a>
            <a class="button" href="<?php echo esc_url( add_query_arg(['page'=>'ch-suscripciones-stripe','activos'=>'1'], admin_url('admin.php')) ); ?>">Con sub. activa</a>
        </p>
        <p style="color:#9ca3af;font-size:12px;margin-top:10px;">* Los filtros de arriba solo son enlaces de conveniencia. Si quieres que afecten al listado, añade el manejo de <code>$_GET</code> en esa pantalla.</p>
    </div>
    <?php
}
