<?php

if (!defined('ABSPATH')) exit;

function pluggin_mostrar_enlaces_por_rol() {
    global $wpdb;

    if (is_user_logged_in()) {
        $user_login = wp_get_current_user()->user_login;
        $rol = $wpdb->get_var(
            $wpdb->prepare("SELECT user_rol FROM mnkt_users WHERE user_login = %s", $user_login)
        );

        ob_start();
        ?>
        <style>
            .pure-menu-button {
                display: none;
            }
            @media (max-width: 768px) {
                .pure-menu-horizontal {
                    display: none;
                }
                .pure-menu-button {
                    display: block;
                    text-align: center;
                    margin: 10px 0;
                    font-size: 16px;
                    background: none;
                    border: none;
                    cursor: pointer;
                    color: #000;
                }
                .pure-menu-open {
                    display: block !important;
                }
            }
        </style>

        <script>
            function toggleRolMenu() {
                var menu = document.getElementById('rol-responsive-menu');
                if (menu.classList.contains('pure-menu-open')) {
                    menu.classList.remove('pure-menu-open');
                } else {
                    menu.classList.add('pure-menu-open');
                }
            }
        </script>

        <button class="pure-menu-button" onclick="toggleRolMenu()">Menú</button>

        <div id="rol-responsive-menu" class="pure-menu pure-menu-horizontal" style="display: flex; justify-content: center; font-size: 13px;">
            <ul class="pure-menu-list">
                <?php if ($rol === 'Gestor'): ?>
                    <li class="pure-menu-item pure-menu-has-children pure-menu-allow-hover">
                        <a href="https://www.educasede.com/app/revision" class="pure-menu-link">Revisión</a>
                        <ul class="pure-menu-children">
                            <li class="pure-menu-item"><a href="https://www.educasede.com/app/revision/informe" class="pure-menu-link">Informe</a></li>
                            <li class="pure-menu-item"><a href="https://www.educasede.com/app/revision/historial" class="pure-menu-link">Historial</a></li>
                        </ul>
                    </li>
                    <li class="pure-menu-item"><a href="https://www.educasede.com/app/revision2" class="pure-menu-link">Revisión2</a></li>
                <?php elseif ($rol === 'Trabajador'): ?>
                    <li class="pure-menu-item"><a href="https://www.educasede.com/app/trabajo" class="pure-menu-link">Panel de Trabajo</a></li>
                    <li class="pure-menu-item"><a href="https://www.educasede.com/app/documentos" class="pure-menu-link">Documentos</a></li>
                <?php elseif ($rol === 'Inspector'): ?>
                    <li class="pure-menu-item"><a href="https://www.educasede.com/app/inspecciones" class="pure-menu-link">Inspecciones</a></li>
                    <li class="pure-menu-item"><a href="https://www.educasede.com/app/informes" class="pure-menu-link">Informes</a></li>
                <?php else: ?>
                    <li class="pure-menu-item"><a href="https://www.educasede.com/app/info" class="pure-menu-link">Información</a></li>
                    <li class="pure-menu-item"><a href="https://www.educasede.com/app/contacto" class="pure-menu-link">Contacto</a></li>
                <?php endif; ?>
            </ul>
        </div>
        <?php

        return ob_get_clean();

    } else {
        return '
            <div class="rol-menu-logo" style="display: flex; justify-content: center; align-items: center;">
                <img src="https://www.educasede.com/wp-content/uploads/2024/08/E-Digital-500-%C3%97-200-px-Trans.png" alt="Educasede" style="max-height: 50px;">
            </div>
        ';
    }
}
add_shortcode('rol_menu_links', 'pluggin_mostrar_enlaces_por_rol');
