<?php
if (!defined('ABSPATH')) exit;

// Shortcode para revisión y edición de fichajes
function revision_trabajadores_shortcode() {
    if (!is_user_logged_in()) {
        return '<p class="pure-alert" style="text-align: center;">No has iniciado sesión.</p>';
    }

    global $wpdb;
    $user_id = get_current_user_id();

    // Verificar rol permitido
   $user_info = $wpdb->get_row($wpdb->prepare("SELECT user_rol, user_estado FROM {$wpdb->prefix}users WHERE ID = %d", $user_id));
if (!$user_info || $user_info->user_rol !== 'Gestor' || $user_info->user_estado !== 'Activado') {
    return '<p class="pure-alert">No tienes permisos para acceder a esta sección.</p>';
}


// Empresas del gestor vía asociaciones (NO desde users)
$empresas = $wpdb->get_results($wpdb->prepare("
    SELECT DISTINCT e.id, e.user_cif, e.razon_social
    FROM {$wpdb->prefix}empresas_usuarios eu
    JOIN {$wpdb->prefix}empresas e ON e.id = eu.empresa_id
    WHERE eu.user_id = %d
      AND eu.rol_en_empresa = 'Gestor'
      AND eu.estado = 'Activado'
    ORDER BY e.razon_social ASC, e.user_cif ASC
", get_current_user_id()));

if (!$empresas) {
    return '<p class="pure-alert" style="text-align:center;">No tienes ninguna empresa asociada como Gestor.</p>';
}

// CIFs disponibles a partir de las asociaciones (para el <select name="cif">)
$cifs = [];
foreach ($empresas as $e) {
    $cifs[] = $e->user_cif;
}

// Determinar CIF activo desde el selector (POST/GET) o usar el primero
if (!session_id()) session_start();
if (isset($_REQUEST['cif']) && in_array($_REQUEST['cif'], $cifs, true)) {
    $_SESSION['cif_activo'] = sanitize_text_field($_REQUEST['cif']);
}
$user_cif = $_SESSION['cif_activo'] ?? ($cifs[0] ?? null);

// Si viene empresa_id, forzamos el CIF acorde
if (isset($_REQUEST['empresa_id']) && ctype_digit($_REQUEST['empresa_id'])) {
    $empId = (int) $_REQUEST['empresa_id'];
    foreach ($empresas as $e) {
        if ((int)$e->id === $empId) {
            $_SESSION['cif_activo'] = $e->user_cif;
            $user_cif = $e->user_cif;
            break;
        }
    }
}

if (!$user_cif) {
    return '<p class="pure-alert">No se pudo determinar un CIF activo válido.</p>';
}
// Detectar empresa activa y si tiene lugares activados
$empresa_id_activa = null;
foreach ($empresas as $e) {
    if ($e->user_cif === $user_cif) {
        $empresa_id_activa = (int) $e->id;
        break;
    }
}

$empresa_tiene_lugares = false;
if ($empresa_id_activa) {
    $estado_lugares = $wpdb->get_var($wpdb->prepare(
        "SELECT estado_lugares FROM {$wpdb->prefix}empresas WHERE id = %d",
        $empresa_id_activa
    ));
    $empresa_tiene_lugares = ($estado_lugares === 'activado');
}


    // Obtener trabajadores con mismo CIF (incluyendo al usuario actual si es gestor)
$trabajadores = $wpdb->get_results($wpdb->prepare(
    "SELECT ID, display_name, user_rol, user_dni
     FROM {$wpdb->prefix}users
     WHERE user_cif = %s
       AND user_rol IN ('Trabajador', 'Gestor')
       AND user_estado = 'Activado'
     ORDER BY display_name ASC",
    $user_cif
));




    // Valores del formulario
    $trabajador_id = isset($_POST['trabajador_id']) ? intval($_POST['trabajador_id']) : '';
   $hoy = current_time('Y-m-d');
$fecha_inicio = isset($_POST['fecha_inicio']) ? sanitize_text_field($_POST['fecha_inicio']) : $hoy;
$fecha_fin = isset($_POST['fecha_fin']) ? sanitize_text_field($_POST['fecha_fin']) : $hoy;


    // ---- Ticar entrada/salida ----
    if (!empty($_POST['accion_ticar'])) {
        if (!isset($_POST['ticar_nonce_field']) || !wp_verify_nonce($_POST['ticar_nonce_field'], 'ticar_nonce')) {
            return '<p style="color:red;">❌ Seguridad fallida al ticar.</p>';
        }

        $trabajador_id_tic = isset($_POST['trabajador_id']) ? intval($_POST['trabajador_id']) : 0;
        if (!$trabajador_id_tic) {
            return '<p style="color:red;">❌ Falta trabajador para ticar.</p>';
        }

        // Validar trabajador del mismo CIF
        $trab_ok = $wpdb->get_row($wpdb->prepare(
            "SELECT ID FROM {$wpdb->prefix}users 
            WHERE ID = %d AND user_cif = %s AND user_estado = 'Activado'",
            $trabajador_id_tic, $user_cif
        ));
        if (!$trab_ok) {
            return '<p style="color:red;">❌ El trabajador no es válido o no pertenece a esta empresa.</p>';
        }

        // ¿Hay registro abierto?
        $registro_abierto = $wpdb->get_row($wpdb->prepare(
            "SELECT id, entradaR 
            FROM mnkt_registro_horario
            WHERE user_id = %d AND cif_usuario = %s AND salida IS NULL
            ORDER BY entrada DESC
            LIMIT 1",
            $trabajador_id_tic, $user_cif
        ));

        // Lugar seleccionado (si viene en el POST)
        $lugar_id = isset($_POST['lugar_id']) ? intval($_POST['lugar_id']) : 0;

        /**
        * Si la empresa tiene lugares activados, NO hay registro abierto (es ENTRADA)
        * y todavía no se ha elegido lugar, paramos aquí y mostramos el selector.
        */
        if ($empresa_tiene_lugares && !$registro_abierto && !$lugar_id) {
           // Carga de lugares de la empresa
            // Carga de lugares de la empresa (tabla real: mnkt_lugares)
            $tabla_lugares = 'mnkt_lugares';

            $lugares = $wpdb->get_results($wpdb->prepare(
                "SELECT id, nombre_lugar 
                FROM $tabla_lugares
                WHERE empresa_id = %d
                AND estado = 'activado'
                ORDER BY nombre_lugar ASC",
                $empresa_id_activa
            ));

            if (empty($lugares)) {
                return '<p class="pure-alert" style="color:#c00;">
                    No hay lugares activados para esta empresa.
                </p>';
            }



            ob_start();
            ?>
            <div class="rh-contenedor" style="margin-top:20px;">
                <div style="background:#fff3cd; border:1px solid #ffeeba; padding:15px; border-radius:6px;">
                    <p style="margin-top:0;"><strong>Selecciona el lugar para este fichaje.</strong></p>

                    <form method="post" class="pure-form pure-form-stacked">
                        <?php wp_nonce_field('ticar_nonce', 'ticar_nonce_field'); ?>
                        <input type="hidden" name="accion_ticar" value="1">
                        <input type="hidden" name="trabajador_id" value="<?php echo esc_attr($trabajador_id_tic); ?>">
                        <input type="hidden" name="fecha_inicio" value="<?php echo esc_attr($fecha_inicio); ?>">
                        <input type="hidden" name="fecha_fin" value="<?php echo esc_attr($fecha_fin); ?>">

                        <label for="lugar_id">📍 Lugar del fichaje:</label>
                        <select name="lugar_id" id="lugar_id" required>
                            <option value="">-- Selecciona un lugar --</option>
                            <?php foreach ($lugares as $l): ?>
                                <option value="<?php echo esc_attr($l->id); ?>">
                                    <?php echo esc_html($l->nombre_lugar); ?>
                                </option>
                            <?php endforeach; ?>
                        </select>

                        <br>
                        <button type="submit" class="pure-button pure-button-primary">
                            ✔️ Confirmar fichaje con este lugar
                        </button>
                    </form>
                </div>
            </div>
            <?php
            return ob_get_clean();
        }

        // A partir de aquí ya tenemos:
        // - o bien registro_abierto (SALIDA)
        // - o bien ENTRADA con $lugar_id informado si la empresa tiene lugares

        $ahora_mysql = current_time('mysql');

        if ($registro_abierto) {
            // SALIDA
            $inicio = strtotime($registro_abierto->entradaR ?: $ahora_mysql);
            $fin    = strtotime($ahora_mysql);
            $diff   = max(0, $fin - $inicio);

            $tiempo_total = sprintf('%02d:%02d:%02d',
                floor($diff / 3600),
                floor(($diff % 3600) / 60),
                $diff % 60
            );

            // Si quieres guardar el lugar también en la salida y tienes columna, descomenta y ajusta:
            // $datos_update_extra = [];
            // if ($empresa_tiene_lugares && $lugar_id) {
            //     $datos_update_extra['id_lugar'] = $lugar_id;
            // }

            $wpdb->update(
                "mnkt_registro_horario",
                array_merge([
                    'salida'        => $ahora_mysql,
                    'salidaR'       => $ahora_mysql,
                    'tiempo_total'  => $tiempo_total,
                    'tiempo_totalR' => $tiempo_total,
                    'puntos'        => -100 // si quieres quitar la penalización en BD, elimina esta línea
                ]/*, $datos_update_extra*/),
                ['id' => $registro_abierto->id]
            );

            // Observación sin mencionar puntos
            $nombre_gestor = wp_get_current_user()->display_name;
            $fecha_obs     = date('Y-m-d', strtotime($ahora_mysql));
            $ts            = date('d/m/Y H:i:s', strtotime($ahora_mysql));
            $obs_txt       = "$ts [Ticar manual por $nombre_gestor] SALIDA";
            $wpdb->insert("{$wpdb->prefix}observaciones", [
                'user_id'          => $trabajador_id_tic,
                'cif_usuario'      => $user_cif,
                'fecha_observacion'=> $fecha_obs,
                'observaciones'    => $obs_txt
            ]);

            $mensaje_exito = '✅ Salida ticada.';
            echo "<script>
                document.addEventListener('DOMContentLoaded', function() {
                    const fila = document.getElementById('registro-id-{$registro_abierto->id}');
                    if(fila) {
                        fila.scrollIntoView({ behavior: 'smooth', block: 'center' });
                        fila.classList.add('resaltado-edicion');
                        setTimeout(() => fila.classList.remove('resaltado-edicion'), 3000);
                    }
                });
            </script>";

        } else {
            // ENTRADA
            $datos_insert = [
                'user_id'        => $trabajador_id_tic,
                'cif_usuario'    => $user_cif,
                'entrada'        => $ahora_mysql,
                'entradaR'       => $ahora_mysql,
                'tiempo_total'   => '00:00:00',
                'tiempo_totalR'  => '00:00:00',
                'puntos'         => -100 
            ];

            // Guardar lugar si la empresa usa lugares y se ha seleccionado
                if ($empresa_tiene_lugares && $lugar_id) {
                    $datos_insert['lugar_id'] = $lugar_id;
                }


            $wpdb->insert("mnkt_registro_horario", $datos_insert);
            $nuevo_id = $wpdb->insert_id;

            $nombre_gestor = wp_get_current_user()->display_name;
            $fecha_obs     = date('Y-m-d', strtotime($ahora_mysql));
            $ts            = date('d/m/Y H:i:s', strtotime($ahora_mysql));
            $obs_txt       = "$ts [Ticar manual por $nombre_gestor] ENTRADA";
            $wpdb->insert("{$wpdb->prefix}observaciones", [
                'user_id'          => $trabajador_id_tic,
                'cif_usuario'      => $user_cif,
                'fecha_observacion'=> $fecha_obs,
                'observaciones'    => $obs_txt
            ]);

            $mensaje_exito = '✅ Entrada ticada.';
            echo "<script>
                document.addEventListener('DOMContentLoaded', function() {
                    const fila = document.getElementById('registro-id-$nuevo_id');
                    if(fila) {
                        fila.scrollIntoView({ behavior: 'smooth', block: 'center' });
                        fila.classList.add('resaltado-edicion');
                        setTimeout(() => fila.classList.remove('resaltado-edicion'), 3000);
                    }
                });
            </script>";
        }
    }



   $mensaje_exito = '';
if (!empty($_POST['editar_id'])) {
    // Validar nonce de seguridad
    if (!isset($_POST['editar_fichaje_nonce_field']) || 
        !wp_verify_nonce($_POST['editar_fichaje_nonce_field'], 'editar_fichaje_nonce')) {
        return '<p style="color:red;">❌ Seguridad fallida: token inválido.</p>';
    }
    $id_editar = intval($_POST['editar_id']);
    $entradaR = sanitize_text_field($_POST['entradaR']);
    $salidaR = sanitize_text_field($_POST['salidaR']);


    $tiempo_totalR = null;
    if ($entradaR && $salidaR) {
       $inicio = strtotime($entradaR);
$fin = strtotime($salidaR);
if ($inicio < $fin) {
    $segundos = $fin - $inicio;

    $horas = floor($segundos / 3600);
    $minutos = floor(($segundos % 3600) / 60);
    $segundos_restantes = $segundos % 60;

    $tiempo_totalR = sprintf('%02d:%02d:%02d', $horas, $minutos, $segundos_restantes);
}

    }

    // Obtener registro original completo (antes de editar)
$registro_original = $wpdb->get_row($wpdb->prepare(
    "SELECT entradaR, salidaR FROM mnkt_registro_horario WHERE id = %d",
    $id_editar
));

$datos_update = [
    'entradaR'      => $entradaR,
    'salidaR'       => $salidaR,
    'tiempo_totalR' => $tiempo_totalR
];

// Si la salidaR estaba vacía, asignamos también salida y tiempo_total
if (empty($registro_original->salidaR)) {
    $datos_update['salida']       = $entradaR;
    $datos_update['puntos']       = -60;
    $datos_update['tiempo_total'] = '00:00:00';
}

$wpdb->update("mnkt_registro_horario", $datos_update, ['id' => $id_editar]);

/**
 * 🔎 Registrar siempre una observación de modificación
 * Formato: [Registro modificado por el gestor (Nombre)] Entrada: antes → después | Salida: antes → después | Tiempo: 07:15:54
 */
$trabajador      = get_userdata($trabajador_id);
$nombre_gestor   = wp_get_current_user()->display_name;
$cif_trabajador  = $trabajador->user_cif;

$fecha_actual        = current_time('Y-m-d H:i:s');
$fecha_observacion   = date('Y-m-d', strtotime($fecha_actual));
$timestamp_formateado = date('d/m/Y H:i:s', strtotime($fecha_actual));

$entrada_antes = !empty($registro_original->entradaR)
    ? date('d/m/Y H:i:s', strtotime($registro_original->entradaR))
    : '—';

$salida_antes = !empty($registro_original->salidaR)
    ? date('d/m/Y H:i:s', strtotime($registro_original->salidaR))
    : '—';

$entrada_despues = !empty($entradaR)
    ? date('d/m/Y H:i:s', strtotime($entradaR))
    : '—';

$salida_despues = !empty($salidaR)
    ? date('d/m/Y H:i:s', strtotime($salidaR))
    : '—';

$tiempo_texto = $tiempo_totalR ?: '00:00:00';

$observacion = sprintf(
    '%s [Registro modificado por el gestor (%s)] Entrada: %s → %s | Salida: %s → %s | Tiempo: %s',
    $timestamp_formateado,
    $nombre_gestor,
    $entrada_antes,
    $entrada_despues,
    $salida_antes,
    $salida_despues,
    $tiempo_texto
);

// OJO: aquí usas "mnkt_observaciones" fijo; si tu tabla real es wp_xxx_observaciones, cambia a {$wpdb->prefix}observaciones
$wpdb->insert("mnkt_observaciones", [
    'user_id'         => $trabajador_id,
    'cif_usuario'     => $cif_trabajador,
    'fecha_observacion' => $fecha_observacion,
    'observaciones'   => $observacion
]);




    // Marcar como éxito
    $mensaje_exito = 'Registro actualizado correctamente.';
    echo "<script>
        document.addEventListener('DOMContentLoaded', function() {
            const fila = document.getElementById('registro-id-$id_editar');
            if(fila) {
                fila.scrollIntoView({ behavior: 'smooth', block: 'center' });
                fila.classList.add('resaltado-edicion');
                setTimeout(() => fila.classList.remove('resaltado-edicion'), 3000);
            }
        });
    </script>";
}


    ob_start();
    ?>

    <h3>Revisión de Fichajes de Trabajadores</h3>
<form method="post" class="pure-form pure-form-stacked">
    <fieldset>
        <div style="display: flex; align-items: center; gap: 10px; flex-wrap: wrap;">
            <div style="display: flex; align-items: center; gap: 5px;">
                <label for="fecha_inicio">Desde:</label>
                <input type="date" name="fecha_inicio" id="fecha_inicio" value="<?php echo esc_attr($fecha_inicio); ?>" required>
            </div>
            <div style="display: flex; align-items: center; gap: 5px;">
                <label for="fecha_fin">Hasta:</label>
                <input type="date" name="fecha_fin" id="fecha_fin" value="<?php echo esc_attr($fecha_fin); ?>" required>
            </div>
          <?php if (count($cifs) > 1): ?>
            <div style="display: flex; align-items: center; gap: 5px;">
                <label for="cif">Empresa:</label>
                <select name="cif" onchange="this.form.submit()">
                    <?php foreach ($empresas as $empresa): ?>
                        <?php
                            $cif_opcion   = $empresa->user_cif;
                            $nombre_opcion = $empresa->razon_social ?: $empresa->user_cif;
                            $label_opcion  = $nombre_opcion . ' (' . $cif_opcion . ')';
                        ?>
                        <option value="<?php echo esc_attr($cif_opcion); ?>" <?php selected($cif_opcion, $user_cif); ?>>
                            <?php echo esc_html($label_opcion); ?>
                        </option>
                    <?php endforeach; ?>
                </select>
                <input type="hidden" name="seleccionar_cif" value="1">
            </div>
            <?php endif; ?>


            <div style="display: flex; align-items: center; gap: 5px;">
                <label for="trabajador_id">Trabajador:</label>
                <select name="trabajador_id" id="trabajador_id">
                    <option value="">-- Selecciona --</option>
                   <?php foreach ($trabajadores as $trabajador): ?>
                    <?php
                    $es_gestor = ($trabajador->user_rol === 'Gestor');
                    $dni = trim((string)($trabajador->user_dni ?? ''));

                    // Si no hay DNI, muestra "sin DNI"
                    $dni_mostrar = $dni !== '' ? $dni : 'sin DNI';

                    // Nombre + rol (si es gestor) + DNI entre paréntesis
                    $nombre_mostrar = $trabajador->display_name
                        . ($es_gestor ? ' (Gestor)' : '')
                        . ' (' . $dni_mostrar . ')';
                    ?>
                    <option value="<?php echo esc_attr($trabajador->ID); ?>" <?php selected($trabajador_id, $trabajador->ID); ?>>
                        <?php echo esc_html($nombre_mostrar); ?>
                    </option>
                <?php endforeach; ?>


                </select>
            </div>
            <button type="submit" class="pure-button pure-button-primary">Consultar</button>

           
        </div>
    </fieldset>
</form>
<div style="margin: 15px 0;">
    <div style="display: flex; gap: 10px; flex-wrap: wrap; align-items: center;">
        <form method="post" action="<?php echo admin_url('admin-post.php'); ?>" target="_blank" style="display:inline;">
            <input type="hidden" name="action" value="generar_pdf_todos_trabajadores">
            <input type="hidden" name="pdf_cif" value="<?php echo esc_attr($user_cif); ?>">
            <input type="hidden" name="pdf_fecha_inicio" value="<?php echo esc_attr($fecha_inicio); ?>">
            <input type="hidden" name="pdf_fecha_fin" value="<?php echo esc_attr($fecha_fin); ?>">
            <button type="submit" class="pure-button pure-button-secondary" title="Resumen de todos los trabajadores">📄 Todos</button>
        </form>

        <form method="post" action="<?php echo admin_url('admin-post.php'); ?>" target="_blank" style="display:inline;">
            <input type="hidden" name="action" value="generar_pdf_detallado_todos_trabajadores">
            <input type="hidden" name="pdf_cif" value="<?php echo esc_attr($user_cif); ?>">
            <input type="hidden" name="pdf_fecha_inicio" value="<?php echo esc_attr($fecha_inicio); ?>">
            <input type="hidden" name="pdf_fecha_fin" value="<?php echo esc_attr($fecha_fin); ?>">
            <input type="hidden" name="incluir_observaciones" value="1">
            <button type="submit" class="pure-button pure-button-secondary" title="PDF detallado de la empresa">🧾 Detalle</button>
        </form>

        <!-- Botón para mostrar trabajadores sin fichar hoy -->
<form method="post" style="display:inline;">
    <input type="hidden" name="accion_listar_ausentes" value="1">
    <button type="submit" class="pure-button pure-button-secondary" title="Ver trabajadores que no han fichado hoy">🚫 Sin fichar hoy</button>
</form>
<?php if ($empresa_tiene_lugares): ?>
    <!-- Informe por lugar (toda la empresa) -->
    <form method="post"
          action="<?php echo admin_url('admin-post.php'); ?>"
          target="_blank"
          style="display:inline;">
        <input type="hidden" name="action" value="generar_pdf_lugares_empresa">
        <input type="hidden" name="pdf_cif" value="<?php echo esc_attr($user_cif); ?>">
        <input type="hidden" name="pdf_fecha_inicio" value="<?php echo esc_attr($fecha_inicio); ?>">
        <input type="hidden" name="pdf_fecha_fin" value="<?php echo esc_attr($fecha_fin); ?>">
        <button type="submit"
                class="pure-button pure-button-secondary"
                title="Informe de registros y tiempos por lugar (toda la empresa)">
            📍 Informe por lugar
        </button>
    </form>
<?php endif; ?>

    </div>
   
</div>




<?php if ($mensaje_exito): ?>
    <div style="background: #d4edda; color: #155724; padding: 10px; border-radius: 5px; text-align: center; margin: 10px 0;">
        <?php echo $mensaje_exito; ?>
    </div>
<?php endif; ?>

    <?php
    if (!empty($trabajador_id) && !empty($fecha_inicio) && !empty($fecha_fin)):

        // Total de horas
        $total_segundos_global = 0;

$registros_global = $wpdb->get_results($wpdb->prepare(
    "SELECT entradaR, salidaR 
     FROM {$wpdb->prefix}registro_horario
     WHERE user_id = %d 
     AND DATE(entradaR) BETWEEN %s AND %s",
    $trabajador_id, $fecha_inicio, $fecha_fin
));

foreach ($registros_global as $r) {
    if ($r->entradaR && $r->salidaR) {
        $inicio = strtotime($r->entradaR);
        $fin = strtotime($r->salidaR);
        if ($fin > $inicio) {
            $total_segundos_global += ($fin - $inicio);
        }
    }
}

$total_tiempo = sprintf('%02d:%02d:%02d',
    floor($total_segundos_global / 3600),
    floor(($total_segundos_global % 3600) / 60),
    $total_segundos_global % 60
);

        ?>
        <div style="text-align: center; font-size: 20px; font-weight: bold; margin-top: 10px;">
            <p>Total: <?php echo $total_tiempo ? esc_html($total_tiempo) : '00:00:00'; ?></p>
            <?php
$inicio_anio = date('Y-01-01');

// Total acumulado desde enero usando tiempo_totalR
$total_desde_enero = $wpdb->get_var("
    SELECT SEC_TO_TIME(SUM(TIME_TO_SEC(tiempo_totalR)))
    FROM {$wpdb->prefix}registro_horario
    WHERE user_id = $trabajador_id AND entradaR >= '$inicio_anio'
");

// Segundos desde enero usando tiempo_totalR
$segundos_desde_enero = $wpdb->get_var("
    SELECT SUM(TIME_TO_SEC(tiempo_totalR))
    FROM {$wpdb->prefix}registro_horario
    WHERE user_id = $trabajador_id AND entradaR >= '$inicio_anio'
");


$dias_transcurridos = (new DateTime())->diff(new DateTime($inicio_anio))->days + 1;
$dias_totales = (new DateTime(date('Y') . '-12-31'))->format('z') + 1;

$estimacion_texto = '';
if ($segundos_desde_enero && $dias_transcurridos > 0) {
    $media_diaria = $segundos_desde_enero / $dias_transcurridos;
    $estimacion_total = $media_diaria * $dias_totales;
    $horas_estimadas = floor($estimacion_total / 3600);
    $estimacion_texto = ' · Estimado: ' . $horas_estimadas . 'h';
}

echo '<p style="font-size: 13px; color: #888; margin-top: 4px;">
    Desde el 1 de enero: ' . ($total_desde_enero ?: '00:00:00') . $estimacion_texto . '
</p>';
?>

        </div>

        <h3>Registros de Horario</h3>
<div style="display: flex; gap: 10px; flex-wrap: wrap; margin-bottom: 15px;">



   <!-- Botón PDF sin observaciones (PRIMARIO) -->
<form method="post" action="<?php echo admin_url('admin-post.php'); ?>" target="_blank" style="display:inline;">
    <input type="hidden" name="action" value="generar_pdf_fichajes">
    <input type="hidden" name="pdf_trabajador_id" value="<?php echo esc_attr($trabajador_id); ?>">
    <input type="hidden" name="pdf_fecha_inicio" value="<?php echo esc_attr($fecha_inicio); ?>">
    <input type="hidden" name="pdf_fecha_fin" value="<?php echo esc_attr($fecha_fin); ?>">
    <button type="submit" class="pure-button pure-button-primary" title="Descargar PDF sin observaciones">📄 Descargar PDF</button>
</form>

<!-- Botón PDF con observaciones -->
<form method="post" action="<?php echo admin_url('admin-post.php'); ?>" target="_blank" style="display:inline;">
    <input type="hidden" name="action" value="generar_pdf_fichajes">
    <input type="hidden" name="pdf_trabajador_id" value="<?php echo esc_attr($trabajador_id); ?>">
    <input type="hidden" name="pdf_fecha_inicio" value="<?php echo esc_attr($fecha_inicio); ?>">
    <input type="hidden" name="pdf_fecha_fin" value="<?php echo esc_attr($fecha_fin); ?>">
    <input type="hidden" name="incluir_observaciones" value="1">
    <button type="submit" class="pure-button pure-button-secondary" title="PDF con observaciones">📝 Observaciones</button>
</form>




<?php if (!empty($trabajador_id)): ?>
    <?php
    // ¿Hay registro abierto? (para decidir si el botón es ENTRADA o SALIDA)
    $abierta_id = $wpdb->get_var($wpdb->prepare(
        "SELECT id FROM mnkt_registro_horario
         WHERE user_id = %d AND cif_usuario = %s AND salida IS NULL
         ORDER BY entrada DESC LIMIT 1",
        $trabajador_id, $user_cif
    ));
    $es_salida = !empty($abierta_id);
    $label_ticar = $es_salida ? 'Ticar salida' : 'Ticar entrada';
    ?>
    <form method="post" style="display:inline;">
        <?php wp_nonce_field('ticar_nonce', 'ticar_nonce_field'); ?>
        <input type="hidden" name="accion_ticar" value="1">
        <input type="hidden" name="trabajador_id" value="<?php echo esc_attr($trabajador_id); ?>">
        <input type="hidden" name="fecha_inicio" value="<?php echo esc_attr($fecha_inicio); ?>">
        <input type="hidden" name="fecha_fin" value="<?php echo esc_attr($fecha_fin); ?>">
        <button type="submit"
                class="pure-button pure-button-secondary"
                title="<?php echo esc_attr($label_ticar); ?>"
                onclick="return confirm('¿Confirmas <?php echo $es_salida ? 'ticar la SALIDA' : 'ticar la ENTRADA'; ?> para este trabajador?');">
            ✔️ <?php echo $label_ticar; ?>
        </button>
    </form>
<?php endif; ?>
<?php if ($empresa_tiene_lugares && !empty($trabajador_id)): ?>
    <!-- Informe del trabajador con sus lugares -->
    <form method="post" action="<?php echo admin_url('admin-post.php'); ?>" target="_blank" style="display:inline;">
        <input type="hidden" name="action" value="generar_pdf_trabajador_lugares">
        <input type="hidden" name="pdf_trabajador_id" value="<?php echo esc_attr($trabajador_id); ?>">
        <input type="hidden" name="pdf_cif" value="<?php echo esc_attr($user_cif); ?>">
        <input type="hidden" name="pdf_fecha_inicio" value="<?php echo esc_attr($fecha_inicio); ?>">
        <input type="hidden" name="pdf_fecha_fin" value="<?php echo esc_attr($fecha_fin); ?>">
        <button type="submit"
                class="pure-button pure-button-secondary"
                title="Informe del trabajador con detalle de lugares">
            👤 Trabajador + lugares
        </button>
    </form>
<?php endif; ?>
</div>




</div>




<div class="rh-contenedor">


        <table class="pure-table pure-table-bordered">
            <thead>
                <tr>
                    <th>Entrada</th>
                    <th>Salida</th>
                    <th>Tiempo</th>
                    <th>Total</th>
                    <th>Guardar</th>
                </tr>
            </thead>
            <tbody>
                <?php
                $registros = $wpdb->get_results($wpdb->prepare(
                    "SELECT id, entradaR, salidaR 
                    FROM mnkt_registro_horario
                    WHERE user_id = %d 
                    AND DATE(entradaR) BETWEEN %s AND %s
                    ORDER BY entradaR DESC",
                    $trabajador_id, $fecha_inicio, $fecha_fin
                ));

                if ($registros) {
                    $registros_por_dia = [];

                    // Agrupar por fecha de entradaR
                    foreach ($registros as $registro) {
                        $fecha = date('Y-m-d', strtotime($registro->entradaR));
                        $registros_por_dia[$fecha][] = $registro;
                    }

                    // Ordenar por fecha descendente
                    krsort($registros_por_dia);

                    $alternar_color = false;

                    foreach ($registros_por_dia as $fecha => $registros_dia):
                        $rowspan = count($registros_dia);
                        $alternar_color = !$alternar_color;
                        $fondo_color = $alternar_color ? '#f8f8f8' : '#ffffff';

                        // Calcular total exacto del día sumando las diferencias reales
                        $total_segundos = 0;
                        foreach ($registros_dia as $r) {
                            if ($r->entradaR && $r->salidaR) {
                                $inicio = strtotime($r->entradaR);
                                $fin = strtotime($r->salidaR);
                                if ($fin > $inicio) {
                                    $total_segundos += ($fin - $inicio);
                                }
                            }
                        }

                        $total_dia = sprintf('%02d:%02d:%02d', floor($total_segundos / 3600), floor(($total_segundos % 3600) / 60), $total_segundos % 60);

                        foreach ($registros_dia as $i => $registro):
                            // Calcular tiempo exacto de este registro
                            $tiempo_exacto = '00:00:00';
                            if ($registro->entradaR && $registro->salidaR) {
                                $inicio = strtotime($registro->entradaR);
                                $fin = strtotime($registro->salidaR);
                                if ($fin > $inicio) {
                                    $diff = $fin - $inicio;
                                    $tiempo_exacto = sprintf('%02d:%02d:%02d', floor($diff / 3600), floor(($diff % 3600) / 60), $diff % 60);
                                }
                            }

                            $id = $registro->id;
                ?>
        <tr id="registro-id-<?php echo $id; ?>" class="fila-editar" style="background-color: <?php echo $fondo_color; ?>;">
            <form method="post" class="fila-editar-form">
            <?php wp_nonce_field('editar_fichaje_nonce', 'editar_fichaje_nonce_field'); ?>

                        <td>
                    <div style="display: flex; align-items: center;">
                    <input type="datetime-local"
                            name="entradaR"
                            step="1"
                            value="<?php echo esc_attr(date('Y-m-d\TH:i:s', strtotime($registro->entradaR))); ?>"
                            required
                            class="pure-input"
                            style="width: 100%;">

                        <?php
                        $geoEntrada = $wpdb->get_row($wpdb->prepare(
                            "SELECT latitud_entrada, longitud_entrada 
                            FROM {$wpdb->prefix}registro_horario 
                            WHERE id = %d", $registro->id
                        ));
                        if (!empty($geoEntrada->latitud_entrada) && !empty($geoEntrada->longitud_entrada)) {
                            $linkEntrada = "https://www.google.com/maps?q={$geoEntrada->latitud_entrada},{$geoEntrada->longitud_entrada}";
                            echo '<a href="' . esc_url($linkEntrada) . '" target="_blank" style="margin-left: 6px; font-size: 18px;" title="Ubicación entrada">📍</a>';
                        }
                        ?>
                    </div>
                </td>


                <td>

    <?php
    $salida_valida = !empty($registro->salidaR);
    $salida_default = $salida_valida
        ? date('Y-m-d\TH:i:s', strtotime($registro->salidaR))
        : date('Y-m-d\TH:i:s', strtotime($registro->entradaR));

    ?>

   <?php if (!$salida_valida): ?>
    <span style="color: #cc0000;">Falta salida</span>
<?php endif; ?>



    <div style="display: flex; align-items: center; margin-top: 5px; <?php echo $salida_valida ? '' : 'display: none;'; ?>" class="selector-salida-wrapper">
        <input type="datetime-local"
            name="salidaR"
            step="1"
            value="<?php echo esc_attr($salida_default); ?>"
            class="pure-input selector-salida"
            style="width: 100%;">

        <?php
        $geoSalida = $wpdb->get_row($wpdb->prepare(
            "SELECT latitud_salida, longitud_salida 
             FROM {$wpdb->prefix}registro_horario 
             WHERE id = %d", $registro->id
        ));
        if (!empty($geoSalida->latitud_salida) && !empty($geoSalida->longitud_salida)) {
            $linkSalida = "https://www.google.com/maps?q={$geoSalida->latitud_salida},{$geoSalida->longitud_salida}";
            echo '<a href="' . esc_url($linkSalida) . '" target="_blank" style="margin-left: 6px; font-size: 18px;" title="Ubicación salida">📍</a>';
        }
        ?>
    </div>
</td>





        <td><span class="tiempo-exacto"><?php echo esc_html($tiempo_exacto); ?></span></td>

        <?php if ($i === 0): ?>
            <?php
            // Estilo para total del día
            list($h, $m, $s) = explode(':', $total_dia);
            $total_horas = (int)$h + ((int)$m / 60) + ((int)$s / 3600);
            $estilo_total_dia = 'text-align: center;';

            if ($total_horas > 12) {
                $estilo_total_dia .= ' background-color: #ffcccc; color: #000;';
            } elseif ($total_horas > 8) {
                $estilo_total_dia .= ' color: #cc0000;';
            }
            ?>
            <td rowspan="<?php echo $rowspan; ?>" style="<?php echo esc_attr($estilo_total_dia); ?>">
                <strong><?php echo esc_html($total_dia); ?></strong>
            </td>
        <?php endif; ?>

        <td style="text-align: center;">
            <input type="hidden" name="trabajador_id" value="<?php echo esc_attr($trabajador_id); ?>">
            <input type="hidden" name="fecha_inicio" value="<?php echo esc_attr($fecha_inicio); ?>">
            <input type="hidden" name="fecha_fin" value="<?php echo esc_attr($fecha_fin); ?>">
            <input type="hidden" name="editar_id" value="<?php echo esc_attr($id); ?>">
            <button type="submit" class="pure-button pure-button-primary guardar-btn" disabled>💾</button>
        </td>
    </form>
</tr>
        <?php
                endforeach;
            endforeach;
        } else {
            echo "<tr><td colspan='5'>No hay registros en este periodo.</td></tr>";
        }
        ?>
    </tbody>
</table>
    </div>

<?php
// Mostrar observaciones

$observaciones = $wpdb->get_results($wpdb->prepare(
    "SELECT fecha_observacion, observaciones 
     FROM {$wpdb->prefix}observaciones 
     WHERE user_id = %d 
     AND fecha_observacion BETWEEN %s AND %s 
     ORDER BY fecha_observacion DESC",
    $trabajador_id, $fecha_inicio, $fecha_fin
));
if ($observaciones): ?>
<div class="rh-contenedor">

    <h3 style="margin-top: 30px;">🗒️ Observaciones en el periodo</h3>
    <ul style="background: #f9f9f9; padding: 15px; border-radius: 8px; list-style: disc inside;">
        <?php foreach ($observaciones as $obs): ?>
            <li>
                <strong><?php echo date('d/m/Y', strtotime($obs->fecha_observacion)); ?>:</strong>
                <?php echo esc_html($obs->observaciones); ?>
            </li>
        <?php endforeach; ?>
    </ul>
</div>
<?php endif; ?>



    <?php endif;  ?>

<?php
if (!empty($_POST['accion_listar_ausentes']) && $user_cif) {
    $hoy = current_time('Y-m-d');

    // Todos los trabajadores activos del CIF
    $trabajadores_cif = $wpdb->get_results($wpdb->prepare(
    "SELECT ID, display_name, user_dni FROM {$wpdb->prefix}users 
     WHERE user_cif = %s 
       AND user_estado = 'Activado' 
       AND user_rol IN ('Trabajador', 'Gestor')
     ORDER BY display_name ASC",
    $user_cif
        ));


    // IDs con fichaje hoy
    $ids_con_fichaje = $wpdb->get_col($wpdb->prepare(
        "SELECT DISTINCT user_id FROM {$wpdb->prefix}registro_horario 
         WHERE DATE(entradaR) = %s AND cif_usuario = %s",
        $hoy, $user_cif
    ));

    // Filtrar los que no han fichado
    $ausentes = array_filter($trabajadores_cif, function($t) use ($ids_con_fichaje) {
        return !in_array($t->ID, $ids_con_fichaje);
    });

    echo "<h3 style='margin-top:30px;'>👥 Trabajadores sin fichaje hoy ($hoy)</h3>";
    if ($ausentes) {
        echo "<ul style='background:#fff3f3; padding:15px; border-radius:5px;'>";
        foreach ($ausentes as $trabajador) {
    $dni = trim((string)($trabajador->user_dni ?? ''));
    $dni_mostrar = $dni !== '' ? $dni : 'sin DNI';
    echo "<li><strong>" . esc_html($trabajador->display_name . ' (' . $dni_mostrar . ')') . "</strong></li>";
}

        echo "</ul>";
    } else {
        echo "<p style='color:green; font-weight:bold;'>Todos han fichado hoy. ✅</p>";
    }
}
?>




<script>
document.addEventListener('DOMContentLoaded', () => {
    const diasAvisados = new Set();

    const recalcularTotalDia = (fecha) => {
        let totalSegundos = 0;

        document.querySelectorAll(`tr[data-dia='${fecha}']`).forEach(fila => {
            const entradaInput = fila.querySelector('input[name="entradaR"]');
            const salidaInput = fila.querySelector('input[name="salidaR"]');

            if (entradaInput && salidaInput && entradaInput.value && salidaInput.value) {
                const e = new Date(entradaInput.value);
                const s = new Date(salidaInput.value);
                if (s > e) {
                    totalSegundos += Math.floor((s - e) / 1000);
                }
            }
        });

        return totalSegundos / 3600; // en horas
    };

    document.querySelectorAll('.fila-editar').forEach(form => {
        const entrada = form.querySelector('input[name="entradaR"]');
        const salida = form.querySelector('input[name="salidaR"]');
        const boton = form.querySelector('.guardar-btn');
        const tiempoExacto = form.querySelector('.tiempo-exacto');

        const originalEntrada = entrada.value;
        const originalSalida = salida.value;

        // Obtener fecha del registro
        const fechaRegistro = entrada.value.split('T')[0];
        form.closest('tr').setAttribute('data-dia', fechaRegistro);

        const calcularDuracion = () => {
            const e = new Date(entrada.value);
            const s = new Date(salida.value);
            const diff = s - e;

            if (diff > 0) {
                const totalSecs = Math.floor(diff / 1000);
                const hh = String(Math.floor(totalSecs / 3600)).padStart(2, '0');
                const mm = String(Math.floor((totalSecs % 3600) / 60)).padStart(2, '0');
                const ss = String(totalSecs % 60).padStart(2, '0');
                tiempoExacto.textContent = `${hh}:${mm}:${ss}`;
                return { horas: totalSecs / 3600, entrada: e, salida: s };
            } else {
                tiempoExacto.textContent = '00:00:00';
                return { horas: 0, entrada: e, salida: s };
            }
        };

        entrada.addEventListener('change', () => {
            boton.disabled = (entrada.value === originalEntrada && salida.value === originalSalida);
            calcularDuracion();
        });

        salida.addEventListener('change', () => {
            boton.disabled = (entrada.value === originalEntrada && salida.value === originalSalida);
            calcularDuracion();
        });

        form.addEventListener('submit', (e) => {
            const { horas, entrada: entradaDate, salida: salidaDate } = calcularDuracion();

            if (salidaDate < entradaDate) {
                alert("⚠️ La hora de salida no puede ser anterior a la hora de entrada.");
                e.preventDefault();
                return;
            }

            if (horas > 8) {
                const hh = String(Math.floor(horas)).padStart(2, '0');
                const mm = String(Math.floor((horas % 1) * 60)).padStart(2, '0');
                alert(`🕒 Atención: se van a registrar ${hh}:${mm} horas.`);
            }

            // Calcular total del día con nuevos datos
            const fecha = entrada.value.split('T')[0];
            if (!diasAvisados.has(fecha)) {
                const totalDia = recalcularTotalDia(fecha);
                if (totalDia > 8) {
                    const totalStr = `${Math.floor(totalDia)}h ${(Math.round((totalDia % 1) * 60))}m`;
                    alert(`📅 Atención: el total del día ${fecha} será ${totalStr}, supera las 8 horas.`);
                    diasAvisados.add(fecha);
                }
            }
        });

        boton.disabled = true;
    });
});
</script>









<?php
    return ob_get_clean();
}
add_shortcode('revision_trabajadores', 'revision_trabajadores_shortcode');



////////////////////Formulario para añadir observaciones desde el perfil de Gestor

function shortcode_formulario_observaciones_trabajador() {
    if (!is_user_logged_in()) return '';

    global $wpdb;
    $usuario = wp_get_current_user();
    $user_id = $usuario->ID;

    // Comprobar si es Gestor y Activado
    $gestor = $wpdb->get_row($wpdb->prepare(
        "SELECT user_cif, user_rol, user_estado FROM {$wpdb->prefix}users WHERE ID = %d", $user_id
    ));

    if (!$gestor || $gestor->user_rol !== 'Gestor' || $gestor->user_estado !== 'Activado') {
        return '';
    }

    $user_cif = $gestor->user_cif;

    // Obtener ID del trabajador seleccionado (vía POST o sesión)
    if (!session_id()) session_start();

    $trabajador_id = 0;

    if (isset($_POST['trabajador_id'])) {
        $trabajador_id = intval($_POST['trabajador_id']);
        $_SESSION['trabajador_id_seleccionado'] = $trabajador_id;
    } elseif (!empty($_SESSION['trabajador_id_seleccionado'])) {
        $trabajador_id = intval($_SESSION['trabajador_id_seleccionado']);
    }

    if (!$trabajador_id) {
        return '<p style="color:orange;">ℹ️ No se ha seleccionado ningún trabajador.</p>';
    }

    $mensaje = '';

    // Procesar envío
    if (!empty($_POST['nueva_observacion']) &&
        isset($_POST['observacion_nonce_field']) &&
        wp_verify_nonce($_POST['observacion_nonce_field'], 'observacion_nonce')) {

        $fecha_observacion = sanitize_text_field($_POST['fecha_observacion']);
        $texto = trim(sanitize_text_field($_POST['observacion_texto']));
        $timestamp = current_time('d/m/Y H:i:s');
        $observacion = "[G] $timestamp $texto";

        // Validar trabajador
        $trabajador = $wpdb->get_row($wpdb->prepare(
            "SELECT user_cif FROM {$wpdb->prefix}users WHERE ID = %d AND user_estado = 'Activado'", $trabajador_id
        ));

        if ($trabajador && $trabajador->user_cif === $user_cif) {
            $resultado = $wpdb->insert("{$wpdb->prefix}observaciones", [
                'user_id' => $trabajador_id,
                'cif_usuario' => $trabajador->user_cif,
                'fecha_observacion' => $fecha_observacion,
                'observaciones' => $observacion
            ]);

            if ($resultado) {
                $mensaje = '<div style="color:green; font-weight:bold;">✅ Observación guardada correctamente.</div>';
            } else {
                $mensaje = '<div style="color:red;">❌ Error al guardar observación: ' . esc_html($wpdb->last_error) . '</div>';
            }
        } else {
            $mensaje = '<div style="color:red;">❌ El trabajador no es válido o no pertenece a tu empresa.</div>';
        }

        // 🧪 DEBUG SIEMPRE ACTIVO
        echo '<div style="margin: 20px 0; padding: 10px; background: #fff9db; border: 1px solid #e6c200; font-family: monospace;">';
        echo "<strong>🧪 DEBUG: Datos recogidos del formulario</strong><br><br>";
        echo "Trabajador ID: " . esc_html($trabajador_id) . "<br>";
        echo "Fecha observación: " . esc_html($fecha_observacion) . "<br>";
        echo "Texto: " . esc_html($texto) . "<br>";
        echo "Timestamp generado: " . esc_html($timestamp) . "<br>";
        echo "Observación final: " . esc_html($observacion) . "<br>";
        echo "</div>";
    }

    ob_start();
    ?>

        <div style="margin-top: 20px;" class="rh-contenedor">
            <h3>✏️ Añadir observación</h3>
            <?php echo $mensaje; ?>
            <form method="post" class="pure-form pure-form-stacked" style="max-width: 400px;">
                <?php wp_nonce_field('observacion_nonce', 'observacion_nonce_field'); ?>
                <input type="hidden" name="trabajador_id" value="<?php echo esc_attr($trabajador_id); ?>">

                <label for="fecha_observacion">📅 Fecha a la que se refiere la observación:</label>
                <input type="date" name="fecha_observacion" required value="<?php echo esc_attr(date('Y-m-d')); ?>">

                <label for="observacion_texto" style="margin-top: 10px;">🗒️ Escribe tu observación:</label>
                <textarea name="observacion_texto" rows="3" required style="width: 100%;"></textarea>

                <br>
                <button type="submit" name="nueva_observacion" class="pure-button pure-button-primary" style="margin-top: 10px;">💾 Guardar observación</button>
            </form>
        </div>

    <?php
    return ob_get_clean();
}
add_shortcode('formulario_observaciones_trabajador', 'shortcode_formulario_observaciones_trabajador');

