<?php


if (!defined('ABSPATH')) exit;

// Procesar entrada/salida y observaciones
function rh_procesar_registro_y_observaciones() {
   if (!is_user_logged_in()) return '';

    $user_id = get_current_user_id();
    $user_info = get_userdata($user_id);

    // Bloquear a Inspectores del acceso visual
    if (in_array('inspector', (array) $user_info->roles)) {
        return '<p class="pure-alert" style="text-align: center;">No tienes acceso a esta sección.</p>';
    }


    global $wpdb;
    $user_id = get_current_user_id();
    $tabla_registro = $wpdb->prefix . 'registro_horario';
    $tabla_observaciones = $wpdb->prefix . 'observaciones';

    // ¿La empresa del usuario tiene lugares activados?
$empresa_id_lugares = (int) $wpdb->get_var($wpdb->prepare(
    "SELECT user_cif_id FROM {$wpdb->prefix}users WHERE ID = %d",
    $user_id
));

$estado_lugares_global = $empresa_id_lugares ? $wpdb->get_var($wpdb->prepare(
    "SELECT estado_lugares FROM {$wpdb->prefix}empresas WHERE id = %d",
    $empresa_id_lugares
)) : 'desactivado';

$empresa_tiene_lugares = ($estado_lugares_global === 'activado');

    $tabla_usuarios = $wpdb->prefix . 'users';

    $cif_usuario = $wpdb->get_var($wpdb->prepare("SELECT user_cif FROM $tabla_usuarios WHERE ID = %d", $user_id));
    $latitud = isset($_POST['latitud']) ? floatval($_POST['latitud']) : null;
    $longitud = isset($_POST['longitud']) ? floatval($_POST['longitud']) : null;
    date_default_timezone_set('Europe/Madrid');
    $hora_actual = date('Y-m-d H:i:s');

  // ➕ NUEVO: capturar y validar lugar_id
$empresa_id_usuario = (int) $wpdb->get_var($wpdb->prepare(
    "SELECT user_cif_id FROM {$wpdb->prefix}users WHERE ID = %d", $user_id
));
$lugar_id_post   = isset($_POST['lugar_id']) ? (int)$_POST['lugar_id'] : 0;
$lugar_id_valido = null;

// (opcional) Refrescar cif_usuario y dni desde BD por si faltan
$cif_empresa = $empresa_id_usuario ? $wpdb->get_var($wpdb->prepare(
    "SELECT user_cif FROM {$wpdb->prefix}empresas WHERE id = %d", $empresa_id_usuario
)) : $cif_usuario;

$user_dni = $wpdb->get_var($wpdb->prepare(
    "SELECT user_dni FROM {$wpdb->prefix}users WHERE ID = %d", $user_id
));


// 1) ¿Requiere lugar la empresa? (lugares activados y NO QR)
$qr_general_empresa = $wpdb->get_var( $wpdb->prepare(
    "SELECT qr_general FROM {$wpdb->prefix}empresas WHERE id = %d",
    $empresa_id_usuario
));
$estado_lugares_empresa = $wpdb->get_var( $wpdb->prepare(
    "SELECT estado_lugares FROM {$wpdb->prefix}empresas WHERE id = %d",
    $empresa_id_usuario
));
$requiere_lugar = ($empresa_id_usuario > 0
    && $estado_lugares_empresa === 'activado'
    && $qr_general_empresa !== 'activado');

// 2) Si requiere lugar y es ENTRADA, pero no viene o no es válido → bloquear
if ( isset($_POST['registrar_entrada']) && $requiere_lugar ) {

    $es_valido = 0;
    if ($lugar_id_post) {
        $es_valido = (int) $wpdb->get_var($wpdb->prepare(
            "SELECT COUNT(*) FROM {$wpdb->prefix}lugares
             WHERE id = %d AND empresa_id = %d AND estado = 'activado'",
            $lugar_id_post, $empresa_id_usuario
        ));
        if ($es_valido) {
            $lugar_id_valido = $lugar_id_post;
        }
    }

    if (!$lugar_id_post || !$es_valido) {
        wp_safe_redirect( add_query_arg('rh_err', 'lugar_req', $_SERVER['REQUEST_URI']) );
        exit;
    }
}

// (Si no requiere lugar, o no es entrada, o no hay lugar → se permite)
// Si hay lugar válido, ya quedó en $lugar_id_valido
if ($lugar_id_post && $lugar_id_valido === null) {
    // Intentaron pasar un lugar inválido (empresa o estado no cuadra): lo ignoramos.
    $lugar_id_valido = null;
}



 // Registro entrada
if ( isset($_POST['registrar_entrada']) ) {
    $wpdb->insert($tabla_registro, [
        'user_id'         => $user_id,
        'cif_usuario'     => $cif_empresa ?: $cif_usuario, // asegura CIF
        'cif_id'          => $empresa_id_usuario,          // guarda id empresa
        'dni'             => $user_dni,                    // si lo tienes
        'entrada'         => $hora_actual,
        'entradaR'        => $hora_actual,
        'latitud_entrada' => $latitud,
        'longitud_entrada'=> $longitud,
        'lugar_id'        => $lugar_id_valido,
    ]);

    if (!defined('DOING_AJAX')) {
        wp_redirect($_SERVER['REQUEST_URI']);
        exit;
    }
}


    // Registro salida
    if (isset($_POST['registrar_salida'])) {
        $registro = $wpdb->get_row("SELECT * FROM $tabla_registro WHERE user_id = $user_id AND salida IS NULL ORDER BY id DESC LIMIT 1");
        if ($registro) {
            $entrada = strtotime($registro->entradaR);
            $salida = strtotime($hora_actual);
            $diferencia_segundos = $salida - $entrada;

$horas = floor($diferencia_segundos / 3600);
$minutos = floor(($diferencia_segundos % 3600) / 60);
$segundos = $diferencia_segundos % 60;

$tiempo_total = sprintf('%02d:%02d:%02d', $horas, $minutos, $segundos);


         $update_data = [
    'salida'          => $hora_actual,
    'salidaR'         => $hora_actual,
    'tiempo_total'    => $tiempo_total,
    'tiempo_totalR'   => $tiempo_total,
    'latitud_salida'  => $latitud,
    'longitud_salida' => $longitud,
];

// ✅ backfill si vino de otro sistema sin empresa
if (empty($registro->cif_id)) {
    $update_data['cif_id'] = $empresa_id_usuario;
}
if (empty($registro->cif_usuario)) {
    $update_data['cif_usuario'] = $cif_empresa ?: $cif_usuario;
}
if (empty($registro->dni) && !empty($user_dni)) {
    $update_data['dni'] = $user_dni;
}

$wpdb->update($tabla_registro, $update_data, ['id' => $registro->id]);


            calcular_puntos_gamificacion($user_id, $registro->id);
            if (!defined('DOING_AJAX')) {
        wp_redirect($_SERVER['REQUEST_URI']);
        exit;
    }
        }
    }

    // Guardar observación
    if (isset($_POST['guardar_observacion'])) {
        $fecha_observacion = sanitize_text_field($_POST['fecha_observacion']);
        $observacion = sanitize_text_field($_POST['observacion']);
        $timestamp = date('d/m/Y H:i:s', current_time('timestamp'));
        $observacion_final = "$timestamp - [$observacion]";

        $wpdb->insert($tabla_observaciones, [
            'user_id' => $user_id,
            'cif_usuario' => $cif_usuario,
            'fecha_observacion' => $fecha_observacion,
            'observaciones' => $observacion_final
        ]);
    }
}
add_action('init', 'rh_procesar_registro_y_observaciones');

// Mostrar formulario completo
function rh_formulario_completo() {
    if (!is_user_logged_in()) return '';

    $user_id = get_current_user_id();
    $user_info = get_userdata($user_id);

    // Verificar rol permitido (solo Gestor o Trabajador)
    global $wpdb;
    $user_rol = $wpdb->get_var($wpdb->prepare("SELECT user_rol FROM {$wpdb->prefix}users WHERE ID = %d", $user_id));

    // ¿La empresa del usuario tiene lugares activados? (para tooltips en el listado)
    $empresa_id_lugares = (int) $wpdb->get_var($wpdb->prepare(
        "SELECT user_cif_id FROM {$wpdb->prefix}users WHERE ID = %d",
        $user_id
    ));

    $estado_lugares_global = $empresa_id_lugares ? $wpdb->get_var($wpdb->prepare(
        "SELECT estado_lugares FROM {$wpdb->prefix}empresas WHERE id = %d",
        $empresa_id_lugares
    )) : 'desactivado';

    $empresa_tiene_lugares = ($estado_lugares_global === 'activado');

    if (!in_array($user_rol, ['Gestor', 'Trabajador'])) {
        return '<p class="pure-alert" style="text-align: center;">No tienes acceso a esta sección.</p>';
    }

    // === NUEVO: si la empresa o la relación están desactivadas, mostrar aviso y salir
$empresa_id_bloq = (int) $wpdb->get_var($wpdb->prepare(
    "SELECT user_cif_id FROM {$wpdb->prefix}users WHERE ID = %d", $user_id
));

$empresa_estado = $empresa_id_bloq ? $wpdb->get_var($wpdb->prepare(
    "SELECT estado_empresa FROM {$wpdb->prefix}empresas WHERE id = %d", $empresa_id_bloq
)) : 'desactivado';

// (opcional pero recomendable) comprobar también la relación del trabajador
$rel_estado = $empresa_id_bloq ? $wpdb->get_var($wpdb->prepare(
    "SELECT estado FROM {$wpdb->prefix}empresas_usuarios WHERE user_id = %d AND empresa_id = %d",
    $user_id, $empresa_id_bloq
)) : 'Desactivado';

if ($empresa_estado !== 'activado' || $rel_estado === 'Desactivado') {
    return '<div style="margin:20px 0;padding:14px 16px;border:1px solid #fecaca;background:#fee2e2;color:#b91c1c;text-align:center;font-weight:700;border-radius:6px;">
                Empresa desactivada
            </div>';
}


    $tabla_registro = $wpdb->prefix . 'registro_horario';
    $tabla_observaciones = $wpdb->prefix . 'observaciones';
    
    // Filtros
    $hoy = date('Y-m-d');
    $ayer = date('Y-m-d', strtotime('-1 day'));
    $lunes_semana = date('Y-m-d', strtotime('monday this week'));
    $domingo_semana = date('Y-m-d', strtotime('sunday this week'));
    $inicio_mes = date('Y-m-01');

    $filtro = $_GET['filtro'] ?? 'hoy';
    $condicion_registros = '';
switch ($filtro) {
    case 'hoy':
        $condicion_observaciones = "AND fecha_observacion = '$hoy'";
        break;
    case 'ayer':
        $condicion_observaciones = "AND fecha_observacion = '$ayer'";
        break;
    case 'semana':
        $condicion_observaciones = "AND fecha_observacion BETWEEN '$lunes_semana' AND '$domingo_semana'";
        break;
    case 'mes':
        $condicion_observaciones = "AND fecha_observacion >= '$inicio_mes'";
        break;
    case 'todos':
        $condicion_observaciones = ""; // sin filtro
        break;
    default:
        $condicion_observaciones = "AND fecha_observacion = '$hoy'"; // por defecto hoy
        break;
}

    switch ($filtro) {
    case 'hoy':
        $condicion_registros = "AND DATE(entradaR) = '$hoy'";
        break;
    case 'ayer':
        $condicion_registros = "AND DATE(entradaR) = '$ayer'";
        break;
    case 'semana':
        $condicion_registros = "AND DATE(entradaR) BETWEEN '$lunes_semana' AND '$domingo_semana'";
        break;
    case 'mes':
        $condicion_registros = "AND DATE(entradaR) >= '$inicio_mes'";
        break;
}

ob_start();

?>
<script>
function obtenerUbicacion(callback) {
    if (navigator.geolocation) {
        navigator.geolocation.getCurrentPosition(
            pos => callback(pos.coords.latitude, pos.coords.longitude),
            () => callback(null, null)
        );
    } else {
        callback(null, null);
    }
}

function registrar(tipo) {
    obtenerUbicacion((lat, lon) => {
        const form = document.createElement("form");
        form.method = "post";
        form.style.display = "none";

        // Acción (entrada/salida)
        const inputTipo = document.createElement("input");
        inputTipo.type = "hidden";
        inputTipo.name = tipo;
        form.appendChild(inputTipo);

        // Geo (si hay)
        if (lat !== null && lon !== null) {
            const iLat = document.createElement("input");
            iLat.type = "hidden";
            iLat.name = "latitud";
            iLat.value = lat;
            form.appendChild(iLat);

            const iLon = document.createElement("input");
            iLon.type = "hidden";
            iLon.name = "longitud";
            iLon.value = lon;
            form.appendChild(iLon);
        }

        // Lugar (si hay select en la página)
        const lugarSelect = document.getElementById("lugar_id_select");
        if (lugarSelect && lugarSelect.value) {
            const inputLugar = document.createElement("input");
            inputLugar.type = "hidden";
            inputLugar.name = "lugar_id";
            inputLugar.value = lugarSelect.value;
            form.appendChild(inputLugar);
        }

        // ✅ BLOQUEO: si es ENTRADA y el lugar es obligatorio, exige selección
        if (tipo === 'registrar_entrada' && typeof window.LUGARES_REQUERIDOS !== 'undefined' && window.LUGARES_REQUERIDOS) {
            if (!lugarSelect || !lugarSelect.value) {
                alert("Selecciona un lugar antes de registrar la ENTRADA.");
                return; // No enviamos
            }
        }

        // Deshabilitar botones para evitar doble click, enviar
        document.querySelectorAll("button").forEach(btn => btn.disabled = true);
        document.body.appendChild(form);
        form.submit();
    });
}
</script>


<div style="text-align:center; margin-bottom:20px;">
<?php
    // ¿Empresa del usuario con QR general activo?
    $cif = $wpdb->get_var( $wpdb->prepare(
        "SELECT user_cif FROM {$wpdb->prefix}users WHERE ID = %d", $user_id
    ) );
    $qr_activado = ( $wpdb->get_var( $wpdb->prepare(
        "SELECT qr_general FROM {$wpdb->prefix}empresas WHERE user_cif = %s", $cif
    ) ) === 'activado' );

    // Bandera JS: ¿hay que exigir lugar en ENTRADA? (lugares activados y NO QR)
    $empresa_id_usuario_js = (int) $wpdb->get_var( $wpdb->prepare(
        "SELECT user_cif_id FROM {$wpdb->prefix}users WHERE ID = %d", $user_id
    ) );
    $estado_lugares_js = $empresa_id_usuario_js ? $wpdb->get_var(
        $wpdb->prepare("SELECT estado_lugares FROM {$wpdb->prefix}empresas WHERE id = %d", $empresa_id_usuario_js)
    ) : 'desactivado';
    $requiere_lugar_js = ($estado_lugares_js === 'activado' && $qr_activado !== true);
?>
<script>
window.LUGARES_REQUERIDOS = <?php echo $requiere_lugar_js ? 'true' : 'false'; ?>;
</script>
<?php
    if ( $qr_activado ) {
        // Modo QR
        $qr_token = $wpdb->get_var( $wpdb->prepare(
            "SELECT qr_token FROM {$wpdb->prefix}users WHERE ID = %d", $user_id
        ) );
        if ( empty($qr_token) ) {
            $qr_token = bin2hex(random_bytes(16));
            $wpdb->update( "{$wpdb->prefix}users", ['qr_token' => $qr_token], ['ID' => $user_id] );
        }
        $url_qr = add_query_arg('token', $qr_token, home_url('/scan'));
        echo '<img src="https://api.qrserver.com/v1/create-qr-code/?size=200x200&data=' . esc_attr($qr_token) . '" alt="QR usuario" />';
    } else {
        // Modo clásico: ENTRADA/SALIDA
        $registro = $wpdb->get_row("SELECT * FROM $tabla_registro WHERE user_id = $user_id AND salida IS NULL ORDER BY id DESC LIMIT 1");

        if ($registro) {
            echo '<button onclick="registrar(\'registrar_salida\')" class="pure-button pure-button-warning">Registrar Salida</button>';
        } else {
            echo '<button onclick="registrar(\'registrar_entrada\')" class="pure-button pure-button-primary">Registrar Entrada</button>';
        }

        // Selector de lugar (si lugares activados)
        $empresa_id_usuario = (int) $wpdb->get_var( $wpdb->prepare(
            "SELECT user_cif_id FROM {$wpdb->prefix}users WHERE ID = %d", $user_id
        ) );
        if ($empresa_id_usuario) {
            $estado_lugares = $wpdb->get_var( $wpdb->prepare(
                "SELECT estado_lugares FROM {$wpdb->prefix}empresas WHERE id = %d", $empresa_id_usuario
            ) );
            if ($estado_lugares === 'activado') {
                $lugar_fijado_id = (!empty($registro) && !empty($registro->lugar_id)) ? (int)$registro->lugar_id : 0;

                $lugares = $wpdb->get_results( $wpdb->prepare(
                    "SELECT id, nombre_lugar FROM {$wpdb->prefix}lugares
                     WHERE empresa_id = %d AND estado = 'activado'
                     ORDER BY nombre_lugar ASC",
                    $empresa_id_usuario
                ) );
              if ($lugares) {
                    echo '<div class="rh-lugar-wrapper">';
                    echo '  <select id="lugar_id_select" ' . ($lugar_fijado_id ? 'disabled' : '') . '>';
                    echo '      <option value="">— Selecciona —</option>';
                    foreach ($lugares as $l) {
                        $selected = ($lugar_fijado_id && (int)$l->id === $lugar_fijado_id) ? 'selected' : '';
                        echo '      <option value="' . esc_attr($l->id) . '" ' . $selected . '>' . esc_html($l->nombre_lugar) . '</option>';
                    }
                    echo '  </select>';

                    if ($lugar_fijado_id) {
                        echo '<div class="rh-lugar-helper">Fijado al fichar la entrada.</div>';
                    } else {
                        echo '<div class="rh-lugar-helper">Obligatorio para fichar la entrada.</div>';
                    }

                    echo '</div>';
                }

            }
        }
    }
?>
</div>



<form method="get" class="pure-form filtros-container" style="text-align:center; margin-bottom:20px;">
    <?php
    function boton_filtro($nombre, $valor, $filtro_actual) {
        $clase = ($filtro_actual == $valor) ? 'pure-button pure-button-primary' : 'pure-button';
        echo "<button type='submit' name='filtro' value='$valor' class='$clase'>$nombre</button> ";
    }
    $filtro_actual = $filtro;
    boton_filtro('Hoy', 'hoy', $filtro_actual);
    boton_filtro('Ayer', 'ayer', $filtro_actual);
    boton_filtro('Semana Actual', 'semana', $filtro_actual);
    boton_filtro('Mes Actual', 'mes', $filtro_actual);
    boton_filtro('Todos', 'todos', $filtro_actual);
    ?>
</form>

<h3>Registros</h3>
<table class="pure-table pure-table-bordered" style="width: 100%; text-align: center;">
    <thead>
        <tr>
            <th>Día</th>
<th>Entrada</th>
<th>Salida</th>
<th>Tiempo</th>
<th>Total del Día</th>

        </tr>
    </thead>
    <tbody>
    <?php
    $query = "SELECT * FROM $tabla_registro WHERE user_id = %d $condicion_registros ORDER BY entradaR DESC";
        $registros = $wpdb->get_results($wpdb->prepare($query, $user_id));

        // Cache de nombres de lugares
        $lugares_cache = [];

        $dias = [];
        foreach ($registros as $r) {
            $fecha = date('Y-m-d', strtotime($r->entradaR));
            $dias[$fecha][] = $r;
        }


    $alternar = true;
   foreach ($dias as $fecha => $registros_dia) {
    // Calcular total del día
    $total_dia_segundos = 0;
    foreach ($registros_dia as $r) {
        if ($r->tiempo_totalR) {
            list($h, $m, $s) = explode(':', $r->tiempo_totalR);
            $total_dia_segundos += ($h * 3600) + ($m * 60) + $s;
        }
    }
$horas_dia = floor($total_dia_segundos / 3600);
$minutos_dia = floor(($total_dia_segundos % 3600) / 60);
$segundos_dia = $total_dia_segundos % 60;

$total_dia = sprintf('%02d:%02d:%02d', $horas_dia, $minutos_dia, $segundos_dia);

 // Estilo de la celda del total del día
$estilo_total_dia = '';
if ($total_dia_segundos >= 43200) {
    $estilo_total_dia = "style='background-color: #f8d7da; color: red; font-weight: bold;'";
} elseif ($total_dia_segundos >= 28800) {
    $estilo_total_dia = "style='color: red;'";
}

$estilo = $alternar ? 'background-color: #f5f5f5;' : 'background-color: #e0e0e0;';
$alternar = !$alternar;

$primero = true;
$rowspan = count($registros_dia);
$fecha_formateada = date('d/m/Y', strtotime($fecha)); // Puedes cambiar el formato

foreach ($registros_dia as $r) {
   $hora_entrada = date('H:i:s', strtotime($r->entradaR));
$hora_salida = $r->salidaR ? date('H:i:s', strtotime($r->salidaR)) : '---';

// Detectar si la salida es al día siguiente
$dia_entrada = date('Y-m-d', strtotime($r->entradaR));
$dia_salida = $r->salidaR ? date('Y-m-d', strtotime($r->salidaR)) : $dia_entrada;
$sufijo_salida = ($dia_salida > $dia_entrada) ? "<sup style='color: gray;'>(+1)</sup>" : '';

// 🔹 Obtener nombre del lugar (solo si la empresa usa lugares)
$lugar_nombre = '';
if ($empresa_tiene_lugares && !empty($r->lugar_id)) {
    $lid = (int) $r->lugar_id;
    if (!isset($lugares_cache[$lid])) {
        $lugares_cache[$lid] = $wpdb->get_var($wpdb->prepare(
            "SELECT nombre_lugar FROM {$wpdb->prefix}lugares WHERE id = %d",
            $lid
        )) ?: '';
    }
    $lugar_nombre = $lugares_cache[$lid];
}

// 🔹 Tooltip solo si hay nombre de lugar
$tooltip_lugar = $lugar_nombre !== '' ? ' title="Lugar: ' . esc_attr($lugar_nombre) . '"' : '';

// ENTRADA: con mapa si hay geo, y tooltip de lugar
if ($r->latitud_entrada) {
    $linkEntrada = "<a href='https://maps.google.com?q={$r->latitud_entrada},{$r->longitud_entrada}' target='_blank'{$tooltip_lugar}>$hora_entrada</a>";
} else {
    // Span para poder aplicar title también sin link
    $linkEntrada = "<span{$tooltip_lugar}>$hora_entrada</span>";
}

// SALIDA: igual que antes
$linkSalida = ($r->salida && $r->latitud_salida)
    ? "<a href='https://maps.google.com?q={$r->latitud_salida},{$r->longitud_salida}' target='_blank'>$hora_salida$sufijo_salida</a>"
    : ($r->salida ? "$hora_salida$sufijo_salida" : '---');


    $tiempo = $r->tiempo_totalR ?: '---';

    echo "<tr style='$estilo'>";

    if ($primero) {
        echo "<td rowspan='$rowspan'>$fecha_formateada</td>";
    }

    echo "<td>$linkEntrada</td>
          <td>$linkSalida</td>
          <td>$tiempo</td>";

    if ($primero) {
        echo "<td $estilo_total_dia rowspan='$rowspan'>$total_dia</td>";
        $primero = false;
    }

    echo "</tr>";
}


    }
    ?>
    </tbody>
</table>


<!-- Total de horas -->
<div style="text-align: center; font-size: 18px; font-weight: bold; margin-top: 10px;">
<?php
$total_tiempo = $wpdb->get_var("SELECT SEC_TO_TIME(SUM(TIME_TO_SEC(tiempo_totalR))) FROM $tabla_registro WHERE user_id = $user_id $condicion_registros");
echo '<p style="font-size: 22px;"><strong>Total: <span style="font-size: 24px;">' . ($total_tiempo ?: '00:00:00') . '</span></strong></p>';
$inicio_anio = date('Y-01-01');

// Total desde el 1 de enero
$total_desde_enero = $wpdb->get_var("
    SELECT SEC_TO_TIME(SUM(TIME_TO_SEC(tiempo_totalR)))
    FROM $tabla_registro
    WHERE user_id = $user_id AND entradaR >= '$inicio_anio'
");


// Total en segundos para el cálculo
$segundos_desde_enero = $wpdb->get_var("
    SELECT SUM(TIME_TO_SEC(tiempo_totalR))
    FROM $tabla_registro
    WHERE user_id = $user_id AND entradaR >= '$inicio_anio'
");


$dias_transcurridos = (new DateTime())->diff(new DateTime($inicio_anio))->days + 1;
$dias_totales = (new DateTime(date('Y') . '-12-31'))->format('z') + 1;

// Estimación en horas enteras
$estimacion_texto = '';
if ($segundos_desde_enero && $dias_transcurridos > 0) {
    $media_diaria = $segundos_desde_enero / $dias_transcurridos;
    $estimacion_total_segundos = $media_diaria * $dias_totales;
    $horas_estimadas = floor($estimacion_total_segundos / 3600);
    $estimacion_texto = ' · Estimado: ' . $horas_estimadas . 'h';
}

// Salida
echo '<p style="font-size: 13px; color: #888; margin-top: 6px;">
    Desde el 1 de enero: ' . ($total_desde_enero ?: '00:00:00') . $estimacion_texto . '
</p>';



?>
</div>
<br>
<br>
<h3 id="observaciones">Registrar Observación</h3>
<form method="post" class="pure-form form-observacion">
    <fieldset>
        <input type="text" name="observacion" placeholder="Escribe tu observación..." required>
        <div class="observacion-fila">
            <input type="date" name="fecha_observacion" value="<?= esc_attr(date('Y-m-d')) ?>" required>
            <button type="submit" name="guardar_observacion" class="pure-button pure-button-primary">Guardar Observación</button>
        </div>
    </fieldset>
</form>


<br>

<h3>Observaciones</h3>
<div class="tabla-responsive">

<table class="pure-table pure-table-bordered">
    <thead>
        <tr>
            <th>Fecha</th>
            <th>Observación</th>
        </tr>
    </thead>
    <tbody>
    <?php
    $query = "SELECT fecha_observacion, observaciones FROM $tabla_observaciones WHERE user_id = %d $condicion_observaciones ORDER BY fecha_observacion DESC";
    $observaciones = $wpdb->get_results($wpdb->prepare($query, $user_id));
    if ($observaciones) {
        foreach ($observaciones as $obs) {
            echo "<tr><td>{$obs->fecha_observacion}</td><td>{$obs->observaciones}</td></tr>";
        }
    } else {
        echo "<tr><td colspan='2'>No hay observaciones registradas.</td></tr>";
    }
    ?>
    </tbody>
</table>
<br>
<div style="text-align: center; margin-top: 20px;">
    <a href="https://www.educasede.com/app/solicitudes/" class="pure-button pure-button-primary">
        ➕ Solicitar permiso o vacaciones
    </a>
</div>

</div>

<?php
    return ob_get_clean();
}
add_shortcode('registro_horario', 'rh_formulario_completo');
