<?php
if (!defined('ABSPATH')) exit;

// Enqueue PureCSS
function cargar_purecss_en_shortcode_puntos() {
    wp_enqueue_style('purecss', 'https://unpkg.com/purecss@3.0.0/build/pure-min.css');
}
add_action('wp_enqueue_scripts', 'cargar_purecss_en_shortcode_puntos');

// Shortcode: [puntos_filtrados]
function shortcode_puntos_filtrados() {
    if (!is_user_logged_in()) return '';

    global $wpdb;
    $user_id = get_current_user_id();
    $tabla_users = $wpdb->prefix . 'users';
    $tabla = $wpdb->prefix . 'registro_horario';

    // Obtener datos del usuario
    $usuario = $wpdb->get_row($wpdb->prepare(
        "SELECT user_estado, user_rol, user_gamificacion, user_cif FROM $tabla_users WHERE ID = %d",
        $user_id
    ));

    if (!$usuario || $usuario->user_estado !== 'Activado' || !in_array($usuario->user_rol, ['Trabajador', 'Gestor'])) {
        return '<p class="pure-alert">No tienes acceso a esta sección.</p>';
    }

    if ((int)$usuario->user_gamificacion !== 1) {
        ob_start(); ?>
        <div style="text-align: center; margin-top: 40px;">
            <h2 style="color: #cc0000;">⚠️ ¡Ups! La gamificación no está activada</h2>
            <p style="font-size: 18px; color: #555;">Habla con tu gestor para activar la aventura de puntos, logros y sorpresas 🎯✨</p>
            <img src="https://media1.giphy.com/media/v1.Y2lkPTc5MGI3NjExYzN2bmhvNGJzeWhyamwwc2p4N2dkb3Z4eWlkNjI3NGdhdnU4emZqZiZlcD12MV9pbnRlcm5hbF9naWZfYnlfaWQmY3Q9Zw/OPU6wzx8JrHna/giphy.gif" style="max-width: 100%; border-radius: 10px; margin-top: 20px;">
        </div>
        <?php return ob_get_clean();
    }

    ob_start();
    ?>
    <div id="puntos-gamificacion-container" style="margin: 30px auto; max-width: 800px; text-align: center;">
        <h2 style="margin-bottom: 10px;">🎯 Tus puntos</h2>
        <div class="filtros-puntos">
    <div class="widget-filtro azul" onclick="mostrarFiltro('7d')">
        <span>📆 Últimos 7 días</span>
    </div>
    <div class="widget-filtro verde" onclick="mostrarFiltro('6m')">
        <span>📅 Últimos 6 meses</span>
    </div>
    <div class="widget-filtro naranja" onclick="mostrarFiltro('12m')">
        <span>📈 Últimos 12 meses</span>
    </div>
</div>


        <div id="resultado-puntos"></div>

        <?php if ($usuario->user_rol === 'Gestor'): ?>
            <p style="font-size: 14px; color: #777;">👔 Estás compitiendo con tus trabajadores activados.</p>
        <?php endif; ?>
    </div>

    <script>
    async function mostrarFiltro(filtro) {
        const container = document.getElementById('resultado-puntos');
        container.innerHTML = '⏳ Cargando...';

        const respuesta = await fetch('<?php echo admin_url('admin-ajax.php'); ?>?action=calcular_puntos_usuario&filtro=' + filtro);
        const data = await respuesta.json();

        const nombres = { '7d': 'últimos 7 días', '6m': 'últimos 6 meses', '12m': 'últimos 12 meses' };
        const medallas = ['🥇', '🥈', '🥉'];
        let top3html = '';

        if (data.top3 && data.top3.length > 0) {
            top3html = '<div style="margin-top: 20px;"><h4>Top 3 en tu empresa</h4><ol style="list-style: none; padding-left: 0;">';
            data.top3.forEach((persona, idx) => {
                top3html += `<li style="font-size: 18px;">${medallas[idx]} ${persona.nombre} — <strong>${persona.total_puntos} pts</strong></li>`;
            });
            top3html += '</ol></div>';
        }

        container.innerHTML = `
            <div style="padding: 20px; background: #f9f9f9; border-radius: 10px; display: inline-block;">
                <h3 style="margin-bottom: 10px;">🔎 Datos de ${nombres[filtro]}</h3>
                <p style="font-size: 36px; font-weight: bold;">${data.puntos} puntos</p>
                <p style="font-size: 20px;">
                    🏅 Estás en la posición 
                    <strong>${data.ranking !== null ? data.ranking : 'Fuera de ranking'}</strong> 
                    de <strong>${data.total}</strong> participantes
                </p>
                ${top3html}
            </div>
        `;
    }
    </script>
    <?php
    return ob_get_clean();
}
add_shortcode('puntos_filtrados', 'shortcode_puntos_filtrados');

// AJAX para calcular puntos
add_action('wp_ajax_calcular_puntos_usuario', 'ajax_calcular_puntos_usuario');

function ajax_calcular_puntos_usuario() {
    if (!is_user_logged_in()) wp_send_json_error();

    global $wpdb;
    $user_id = get_current_user_id();
    $filtro = $_GET['filtro'] ?? '7d';
    $tabla = $wpdb->prefix . 'registro_horario';
    $tabla_users = $wpdb->prefix . 'users';

    $usuario = $wpdb->get_row($wpdb->prepare(
        "SELECT user_cif FROM $tabla_users WHERE ID = %d",
        $user_id
    ));

  if ($filtro === '6m') {
    $desde = date('Y-m-d', strtotime('-6 months'));
} elseif ($filtro === '12m') {
    $desde = date('Y-m-d', strtotime('-12 months'));
} else {
    $desde = date('Y-m-d', strtotime('-7 days'));
}


    // Obtener puntos del usuario
    $puntos = (int) $wpdb->get_var($wpdb->prepare(
        "SELECT SUM(puntos) FROM $tabla WHERE user_id = %d AND entrada >= %s",
        $user_id, $desde
    ));

    // Obtener ranking
    $resultados = $wpdb->get_results($wpdb->prepare(
        "SELECT user_id, SUM(puntos) AS total_puntos 
         FROM $tabla 
         WHERE entrada >= %s AND user_id IN (
             SELECT ID FROM $tabla_users 
             WHERE user_cif = %s AND user_estado = 'Activado' AND user_rol IN ('Trabajador', 'Gestor')
         ) 
         GROUP BY user_id 
         ORDER BY total_puntos DESC",
        $desde, $usuario->user_cif
    ));

    $ranking = null;
    foreach ($resultados as $index => $fila) {
        if ((int)$fila->user_id === $user_id) {
            $ranking = $index + 1;
            break;
        }
    }

    $top_3 = array_slice($resultados, 0, 3);
    foreach ($top_3 as $i => $fila) {
        $nombre = $wpdb->get_var($wpdb->prepare("SELECT display_name FROM $tabla_users WHERE ID = %d", $fila->user_id));
        $top_3[$i]->nombre = $nombre;
    }

    wp_send_json([
        'puntos' => $puntos,
        'ranking' => $ranking,
        'total' => count($resultados),
        'top3' => $top_3
    ]);
}


/////////////////////CODIGO PARA EL listado de RANKING SI SOY GESTOR



if (!defined('ABSPATH')) exit;

// Enqueue PureCSS si no está cargado
function ranking_empresa_enqueue() {
    wp_enqueue_style('purecss', 'https://unpkg.com/purecss@3.0.0/build/pure-min.css');
}
add_action('wp_enqueue_scripts', 'ranking_empresa_enqueue');

// SHORTCODE: [ranking_empresa]
function shortcode_ranking_empresa() {
    if (!is_user_logged_in()) return '';

    global $wpdb;
    $user_id = get_current_user_id();
    $tabla_users = $wpdb->prefix . 'users';

    $usuario = $wpdb->get_row($wpdb->prepare(
        "SELECT user_cif, user_estado, user_rol FROM $tabla_users WHERE ID = %d",
        $user_id
    ));

    if (!$usuario || $usuario->user_estado !== 'Activado' || $usuario->user_rol !== 'Gestor') {
        return '<p style="text-align:center; color: red;">⚠️ Solo disponible para Gestores activados.</p>';
    }

    ob_start(); ?>
    <div style="max-width: 800px; margin: 0 auto; text-align: center;">
        <h2>📊 Ranking de Puntos de la Empresa</h2>

        <div class="filtros-puntos">
            <div class="widget-filtro azul" onclick="verRanking('7d')">
                <span>📆 Últimos 7 días</span>
            </div>
            <div class="widget-filtro verde" onclick="verRanking('6m')">
                <span>📅 Últimos 6 meses</span>
            </div>
            <div class="widget-filtro naranja" onclick="verRanking('12m')">
                <span>📈 Últimos 12 meses</span>
            </div>
        </div>

        <div id="ranking-contenedor" style="margin-top: 30px;"></div>
    </div>

    <style>
        .filtros-puntos {
            display: flex;
            flex-wrap: wrap;
            gap: 20px;
            justify-content: center;
            margin: 30px auto;
        }

        .widget-filtro {
            cursor: pointer;
            border-radius: 12px;
            padding: 25px 30px;
            text-align: center;
            flex: 1 1 200px;
            min-width: 180px;
            max-width: 250px;
            box-shadow: 0 2px 8px rgba(0,0,0,0.08);
            transition: transform 0.2s, box-shadow 0.2s;
            font-size: 18px;
            font-weight: 600;
        }

        .widget-filtro:hover {
            transform: translateY(-3px);
            box-shadow: 0 4px 12px rgba(0,0,0,0.15);
        }

        .azul { background: #e6f3ff; border: 2px solid #3399ff; color: #003366; }
        .verde { background: #e8fff0; border: 2px solid #33cc66; color: #1a472a; }
        .naranja { background: #fff3e0; border: 2px solid #ffaa33; color: #8a4b00; }

        .ranking-item {
            padding: 12px 20px;
            margin-bottom: 10px;
            border-radius: 8px;
            background: #f9f9f9;
            box-shadow: 0 1px 4px rgba(0,0,0,0.05);
            display: flex;
            justify-content: space-between;
            align-items: center;
            font-size: 16px;
        }
    </style>

    <script>
    async function verRanking(filtro) {
        const contenedor = document.getElementById('ranking-contenedor');
        contenedor.innerHTML = '⏳ Cargando ranking...';

        const respuesta = await fetch('<?php echo admin_url('admin-ajax.php'); ?>?action=ranking_trabajadores_empresa&filtro=' + filtro);
        const data = await respuesta.json();

        const nombres = { '7d': 'últimos 7 días', '6m': 'últimos 6 meses', '12m': 'últimos 12 meses' };
        const medallas = ['🥇', '🥈', '🥉'];

        let html = `<h3 style="margin-bottom: 20px;">🏆 Ranking ${nombres[filtro]}</h3>`;

        if (data.length > 0) {
            data.forEach((persona, index) => {
                const posicion = index + 1;
                const insignia = medallas[index] ?? `#${posicion}`;
                html += `<div class="ranking-item">
                            <div>${insignia} ${persona.nombre}</div>
                            <div><strong>${persona.puntos} pts</strong></div>
                         </div>`;
            });
        } else {
            html += '<p style="color: #999;">No hay datos disponibles para este periodo.</p>';
        }

        contenedor.innerHTML = html;
    }
    </script>
    <?php
    return ob_get_clean();
}
add_shortcode('ranking_empresa', 'shortcode_ranking_empresa');

// AJAX backend
add_action('wp_ajax_ranking_trabajadores_empresa', 'ranking_trabajadores_empresa');

function ranking_trabajadores_empresa() {
    if (!is_user_logged_in()) wp_send_json([]);

    global $wpdb;
    $user_id = get_current_user_id();
    $tabla = $wpdb->prefix . 'registro_horario';
    $tabla_users = $wpdb->prefix . 'users';
    $filtro = $_GET['filtro'] ?? '7d';

    $usuario = $wpdb->get_row($wpdb->prepare(
        "SELECT user_cif FROM $tabla_users WHERE ID = %d AND user_estado = 'Activado' AND user_rol = 'Gestor'",
        $user_id
    ));

    if (!$usuario) wp_send_json([]);

    if ($filtro === '6m') {
        $desde = date('Y-m-d', strtotime('-6 months'));
    } elseif ($filtro === '12m') {
        $desde = date('Y-m-d', strtotime('-12 months'));
    } else {
        $desde = date('Y-m-d', strtotime('-7 days'));
    }

    $resultados = $wpdb->get_results($wpdb->prepare(
        "SELECT user_id, SUM(puntos) AS puntos FROM $tabla
         WHERE entrada >= %s AND user_id IN (
            SELECT ID FROM $tabla_users
            WHERE user_cif = %s AND user_estado = 'Activado' AND user_rol = 'Trabajador'
         )
         GROUP BY user_id
         ORDER BY puntos DESC",
        $desde, $usuario->user_cif
    ));

    $ranking = [];

    foreach ($resultados as $fila) {
        $nombre = $wpdb->get_var($wpdb->prepare(
            "SELECT display_name FROM $tabla_users WHERE ID = %d", $fila->user_id
        ));
        $ranking[] = [
            'nombre' => $nombre,
            'puntos' => (int)$fila->puntos
        ];
    }

    wp_send_json($ranking);
}
