<?php
if (!defined('ABSPATH')) exit;

function shortcode_gestion_permisos_empresa() {
    if (!is_user_logged_in()) {
        return '<p class="pure-alert">Debes iniciar sesión para acceder a esta sección.</p>';
    }

    global $wpdb;
    $user = wp_get_current_user();

    $usuario = $wpdb->get_row($wpdb->prepare("SELECT user_rol, user_estado, user_cif FROM {$wpdb->prefix}users WHERE ID = %d", $user->ID));

    if (!$usuario || $usuario->user_rol !== 'Gestor' || $usuario->user_estado !== 'Activado') {
        return '<p class="pure-alert">No tienes permisos para acceder a esta sección.</p>';
    }

// Obtener todos los CIFs activos del gestor
$cif_registros = $wpdb->get_results($wpdb->prepare(
    "SELECT DISTINCT user_cif FROM {$wpdb->prefix}users 
     WHERE user_email = %s AND user_rol = 'Gestor' AND user_estado = 'Activado'",
    $user->user_email
));
$cifs = array_map(fn($r) => $r->user_cif, $cif_registros);

if (isset($_GET['cif']) && in_array($_GET['cif'], $cifs)) {
    $_SESSION['cif_activo'] = sanitize_text_field($_GET['cif']);
}
$cif = $_SESSION['cif_activo'] ?? ($cifs[0] ?? null);

if (!$cif || !in_array($cif, $cifs)) {
    return '<p class="pure-alert">No se pudo determinar un CIF activo válido.</p>';
}
$estado_filtro = isset($_GET['estado']) ? sanitize_text_field($_GET['estado']) : 'pendiente,aprobado';
    $desde = isset($_GET['desde']) ? sanitize_text_field($_GET['desde']) : '';
    $hasta = isset($_GET['hasta']) ? sanitize_text_field($_GET['hasta']) : '';
    $trabajador_id = isset($_GET['trabajador_id']) ? intval($_GET['trabajador_id']) : 0;

    $estados = explode(',', $estado_filtro);
    $placeholders = implode(',', array_fill(0, count($estados), '%s'));
    $where = ["cif_usuario = %s"];
    $params = [$cif];

    if ($desde) {
        $where[] = "fecha_inicio >= %s";
        $params[] = $desde;
    }
    if ($hasta) {
        $where[] = "fecha_fin <= %s";
        $params[] = $hasta;
    }
    if ($trabajador_id) {
        $where[] = "user_id = %d";
        $params[] = $trabajador_id;
    }

if ($estado_filtro !== 'todos') {
    $estados = explode(',', $estado_filtro);
    $placeholders = implode(',', array_fill(0, count($estados), '%s'));
    $where[] = "estado IN ($placeholders)";
    $params = array_merge($params, $estados);
}

    $sql = "SELECT * FROM {$wpdb->prefix}solicitudes WHERE " . implode(' AND ', $where) . " ORDER BY fecha_solicitud DESC";
    $solicitudes = $wpdb->get_results($wpdb->prepare($sql, $params));

    $trabajadores = $wpdb->get_results($wpdb->prepare(
    "SELECT ID, display_name FROM {$wpdb->prefix}users 
     WHERE user_cif = %s 
     AND user_estado = 'Activado' 
     AND user_rol IN ('Gestor', 'Trabajador')",
    $cif
));


    ob_start();
    ?>
    <h2>Gestión de Solicitudes de Permiso</h2>

    <form method="get" class="pure-form pure-form-stacked" style="margin-bottom: 20px; max-width: 800px;">
        <input type="hidden" name="page" value="gestion_permisos_empresa">

<div style="display: flex; gap: 20px; flex-wrap: wrap;">
    <div>
        <label>Estado:</label>
        <select name="estado">
            <option value="pendiente,aprobado" <?php selected($estado_filtro, 'pendiente,aprobado'); ?>>Pendiente + Aprobadas</option>
            <option value="pendiente" <?php selected($estado_filtro, 'pendiente'); ?>>Solo Pendientes</option>
            <option value="aprobado" <?php selected($estado_filtro, 'aprobado'); ?>>Solo Aprobadas</option>
            <option value="rechazado" <?php selected($estado_filtro, 'rechazado'); ?>>Solo Rechazadas</option>
            <option value="pendiente,aprobado,rechazado" <?php selected($estado_filtro, 'pendiente,aprobado,rechazado'); ?>>Todos</option>
        </select>
    </div>

    <div>
        <label>Desde:</label>
        <input type="date" name="desde" value="<?php echo esc_attr($desde); ?>">
    </div>

    <div>
        <label>Hasta:</label>
        <input type="date" name="hasta" value="<?php echo esc_attr($hasta); ?>">
    </div>
</div>


        <div style="display: flex; gap: 20px; flex-wrap: wrap; align-items: flex-end;">
    <?php if (count($cifs) > 1): ?>
        <div>
            <label>Empresa:</label>
            <select name="cif" onchange="this.form.submit()">
                <?php foreach ($cifs as $c): ?>
                    <option value="<?php echo esc_attr($c); ?>" <?php selected($c, $cif); ?>>
                        <?php echo esc_html($c); ?>
                    </option>
                <?php endforeach; ?>
            </select>
        </div>
    <?php endif; ?>

    <div>
        <label>Trabajador:</label>
        <select name="trabajador_id">
            <option value="">Todos</option>
           <?php foreach ($trabajadores as $t): 
    $nombre_mostrar = $t->display_name;
    $datos_usuario = get_userdata($t->ID);
    if (in_array('gestor', $datos_usuario->roles)) {
        $nombre_mostrar = '(Gestor) ' . $nombre_mostrar;
    }
?>
    <option value="<?php echo $t->ID; ?>" <?php selected($trabajador_id, $t->ID); ?>>
        <?php echo esc_html($nombre_mostrar); ?>
    </option>
<?php endforeach; ?>

        </select>
    </div>
</div>

            

        <button type="submit" class="pure-button pure-button-primary" style="margin-top: 10px;">Filtrar</button>
    </form>

    <?php if ($solicitudes): ?>
        <table class="pure-table tabla-solicitudes" style="max-width: 1000px;">
            <thead>
                <tr>
                    <th>Trabajador</th>
                    <th>Tipo</th>
                    <th>Desde</th>
                    <th>Hasta</th>
                    <th>Motivo</th>
                    <th>Estado</th>
                    <th>Acción</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($solicitudes as $s): 
                    $trabajador = get_userdata($s->user_id);
                    $nombre = $trabajador ? $trabajador->display_name : '—';
                ?>
                    <tr>
                        <td><?php echo esc_html($nombre); ?></td>
                        <td><?php echo ucfirst($s->tipo); ?></td>
                        <td><?php echo date('d/m/Y', strtotime($s->fecha_inicio)); ?></td>
                        <td><?php echo date('d/m/Y', strtotime($s->fecha_fin)); ?></td>
                        <td><?php echo esc_html($s->motivo); ?></td>
<td>
    <?php
    $estado = strtolower($s->estado);
    $color = '#000';

    if ($estado === 'aprobado') {
        $color = 'green';
    } elseif ($estado === 'rechazado') {
        $color = 'red';
    } elseif ($estado === 'pendiente') {
        $color = '#555';
    }

    echo "<span style='color: $color; font-weight: bold;'>" . ucfirst($estado) . "</span>";
    ?>
</td>
                       <td>
    <a href="<?php echo esc_url(admin_url("admin-post.php?action=responder_solicitud&id={$s->id}&respuesta=aprobado")); ?>"
       class="pure-button" style="background: #cfc;">Aprobar</a>
    
    <a href="<?php echo esc_url(admin_url("admin-post.php?action=responder_solicitud&id={$s->id}&respuesta=rechazado")); ?>"
       class="pure-button" style="background: #fdd;">Rechazar</a>
</td>

                    </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    <?php else: ?>
        <p>No hay solicitudes que coincidan con los filtros seleccionados.</p>
    <?php endif; ?>
    <?php
    
    return ob_get_clean();
}
add_shortcode('gestion_permisos_empresa', 'shortcode_gestion_permisos_empresa');

function shortcode_calendario_vacaciones() {
    if (!isset($_GET['cif'])) {
        return '<p class="pure-alert">No se ha definido ningún CIF.</p>';
    }

    global $wpdb;

    $cif = sanitize_text_field($_GET['cif']);

    // Obtener todas las solicitudes aprobadas de ese CIF
    $solicitudes = $wpdb->get_results($wpdb->prepare(
        "SELECT s.*, u.display_name 
         FROM {$wpdb->prefix}solicitudes s 
         JOIN {$wpdb->prefix}users u ON s.user_id = u.ID 
         WHERE s.estado = 'aprobado' AND s.cif_usuario = %s",
        $cif
    ));

    ob_start();
    echo '
    <link href="https://cdn.jsdelivr.net/npm/fullcalendar@6.1.8/main.min.css" rel="stylesheet" />
    <script src="https://cdn.jsdelivr.net/npm/fullcalendar@6.1.8/main.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/fullcalendar@6.1.8/locales-all.min.js"></script>

    <div id="calendario-vacaciones" style="max-width: 1000px; margin: 40px auto;"></div>

    <script>
    document.addEventListener("DOMContentLoaded", function () {
        var calendario = document.getElementById("calendario-vacaciones");
        var calendar = new FullCalendar.Calendar(calendario, {
            initialView: "dayGridMonth",
            locale: "es",
            headerToolbar: {
                left: "prev,next today",
                center: "title",
                right: "dayGridMonth"
            },
            events: [';

    foreach ($solicitudes as $s) {
        $nombre = esc_js($s->display_name);
        $color = ($s->tipo === 'vacaciones') ? '#28a745' : '#007bff';
        $inicio = esc_js($s->fecha_inicio);
        $fin = date('Y-m-d', strtotime($s->fecha_fin . ' +1 day'));

        echo "
            {
                title: '{$nombre} ({$s->tipo})',
                start: '{$inicio}',
                end: '{$fin}',
                backgroundColor: '{$color}',
                borderColor: '{$color}'
            },";
    }

    echo '
            ]
        });
        calendar.render();
    });
    </script>';

    return ob_get_clean();
}
add_shortcode('calendario_vacaciones', 'shortcode_calendario_vacaciones');
