<?php
global $wpdb;
$tabla_shortcodes = $wpdb->prefix . 'shortcodes_info';
$mensaje = '';

// Procesar nuevo shortcode
if (isset($_POST['guardar_shortcode'])) {
    $shortcode = sanitize_text_field($_POST['shortcode']);
    $descripcion = sanitize_textarea_field($_POST['descripcion']);

    if (isset($_POST['id']) && $_POST['id'] != '') {
        $wpdb->update($tabla_shortcodes, [
            'shortcode' => $shortcode,
            'descripcion' => $descripcion
        ], ['id' => intval($_POST['id'])]);
        $mensaje = '<div class="updated"><p>Shortcode actualizado correctamente.</p></div>';
    } else {
        $wpdb->insert($tabla_shortcodes, [
            'shortcode' => $shortcode,
            'descripcion' => $descripcion
        ]);
        $mensaje = '<div class="updated"><p>Shortcode añadido correctamente.</p></div>';
    }
}

// Cargar para editar
$edit_shortcode = null;
if (isset($_GET['editar'])) {
    $edit_shortcode = $wpdb->get_row($wpdb->prepare("SELECT * FROM $tabla_shortcodes WHERE id = %d", intval($_GET['editar'])));
}

// Eliminar
if (isset($_GET['eliminar'])) {
    $wpdb->delete($tabla_shortcodes, ['id' => intval($_GET['eliminar'])]);
    $mensaje = '<div class="updated"><p>Shortcode eliminado.</p></div>';
}

$shortcodes = $wpdb->get_results("SELECT * FROM $tabla_shortcodes");
?>

<div class="wrap">
    <h1>📑 Gestión de Shortcodes</h1>
    <?php echo $mensaje; ?>

    <a href="?page=control-horario&tab=shortcodes&nuevo=1" class="button button-primary">➕ Añadir Shortcode</a>

    <?php if (isset($_GET['nuevo']) || $edit_shortcode): ?>
        <h2><?php echo $edit_shortcode ? 'Editar Shortcode' : 'Nuevo Shortcode'; ?></h2>
        <form method="post">
            <input type="hidden" name="id" value="<?php echo esc_attr($edit_shortcode->id ?? ''); ?>">
            <table class="form-table">
                <tr>
                    <th><label for="shortcode">Shortcode:</label></th>
                    <td><input type="text" name="shortcode" class="regular-text" value="<?php echo esc_attr($edit_shortcode->shortcode ?? ''); ?>" required></td>
                </tr>
                <tr>
                    <th><label for="descripcion">Descripción:</label></th>
                    <td><textarea name="descripcion" rows="4" class="large-text" required><?php echo esc_textarea($edit_shortcode->descripcion ?? ''); ?></textarea></td>
                </tr>
            </table>
            <p><input type="submit" name="guardar_shortcode" class="button button-primary" value="Guardar"></p>
        </form>
    <?php endif; ?>

    <h2>Listado de Shortcodes</h2>
    <table class="wp-list-table widefat fixed striped">
        <thead>
            <tr>
                <th>Shortcode</th>
                <th>Descripción</th>
                <th>Acciones</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($shortcodes as $s): ?>
                <tr>
                    <td><code>[<?php echo esc_html($s->shortcode); ?>]</code></td>
                    <td><?php echo esc_html($s->descripcion); ?></td>
                    <td>
                        <a href="?page=control-horario&tab=shortcodes&editar=<?php echo $s->id; ?>" class="button">Editar</a>
                        <a href="?page=control-horario&tab=shortcodes&eliminar=<?php echo $s->id; ?>" class="button" onclick="return confirm('¿Eliminar este shortcode?');">Eliminar</a>
                    </td>
                </tr>
            <?php endforeach; ?>
            <?php if (empty($shortcodes)): ?>
                <tr><td colspan="3">No hay shortcodes registrados.</td></tr>
            <?php endif; ?>
        </tbody>
    </table>
</div>
