<?php
if (!defined('ABSPATH')) exit;

global $wpdb;
$tabla_usuarios = $wpdb->prefix . 'users';

// Mensaje de acción
$mensaje = '';

// Activar / Desactivar usuario
if (isset($_GET['toggle'])) {
    $id = intval($_GET['toggle']);
    $estado_actual = $wpdb->get_var($wpdb->prepare("SELECT user_estado FROM $tabla_usuarios WHERE ID = %d", $id));
    $nuevo_estado = ($estado_actual === 'Activado') ? 'Desactivado' : 'Activado';
    $wpdb->update($tabla_usuarios, ['user_estado' => $nuevo_estado], ['ID' => $id]);
wp_redirect(add_query_arg([
    'page' => 'control-horario',
    'tab' => 'inspectores',
    'estado' => isset($_GET['estado']) ? sanitize_text_field($_GET['estado']) : 'Activado'
], admin_url('admin.php')));
exit;

}

// Reenviar contraseña
if (isset($_GET['reenviar'])) {
    $id = intval($_GET['reenviar']);
    $user = get_userdata($id);
    if ($user) {
        retrieve_password($user->user_login);
        $mensaje = "<div class='updated'><p>Email de recuperación enviado a " . esc_html($user->user_email) . "</p></div>";
    }
}

// Filtro por estado
$estado_filtro = isset($_GET['estado']) ? sanitize_text_field($_GET['estado']) : 'Activado';
$condicion_estado = ($estado_filtro !== 'todos') ? $wpdb->prepare("AND user_estado = %s", $estado_filtro) : '';

// Obtener lista de inspectores
$inspectores = $wpdb->get_results("SELECT ID, user_login, user_email, user_cif, user_estado FROM $tabla_usuarios WHERE user_rol = 'Inspector' $condicion_estado");

// Obtener CIFs únicos para asignar a inspectores
$cifs = $wpdb->get_col("SELECT DISTINCT user_cif FROM $tabla_usuarios WHERE user_rol = 'Gestor' AND user_estado = 'Activado' AND user_cif != ''");

// Procesar creación de nuevo inspector
if (isset($_POST['crear_inspector'])) {
    $nombre = sanitize_text_field($_POST['user_login']);
    $email = sanitize_email($_POST['user_email']);
    $cif = sanitize_text_field($_POST['user_cif']);
    $password = wp_generate_password();

    $user_id = wp_insert_user([
        'user_login' => $nombre,
        'user_email' => $email,
        'user_pass' => $password,
        'role' => 'inspector'
    ]);

    if (!is_wp_error($user_id)) {
        $wpdb->update($tabla_usuarios, [
            'user_cif' => $cif,
            'user_estado' => 'Activado',
            'user_rol' => 'Inspector'
        ], ['ID' => $user_id]);

        wp_mail($email, 'Bienvenido a E-Digitiall', "Tu usuario: $nombre\nContraseña: $password", [
            'Content-Type: text/plain; charset=UTF-8',
            'From: E-Digitiall <no-reply@educasede.com>'
        ]);

        $mensaje = "<div class='updated'><p>Inspector creado correctamente y correo enviado.</p></div>";
    } else {
        $mensaje = "<div class='error'><p>Error al crear el inspector: " . $user_id->get_error_message() . "</p></div>";
    }
}
?>

<div class="wrap">
    <h1>Gestión de Inspectores</h1>
    <?php echo $mensaje; ?>

    <form method="get" style="margin-bottom: 20px;">
        <input type="hidden" name="page" value="control-horario">
        <input type="hidden" name="tab" value="inspectores">
        <label>Filtrar por estado:
            <select name="estado" onchange="this.form.submit()">
                <option value="todos" <?php selected($estado_filtro, 'todos'); ?>>Todos</option>
                <option value="Activado" <?php selected($estado_filtro, 'Activado'); ?>>Activados</option>
                <option value="Desactivado" <?php selected($estado_filtro, 'Desactivado'); ?>>Desactivados</option>
            </select>
        </label>
    </form>

    <a href="#" class="button button-primary" onclick="document.getElementById('nuevo-inspector-form').style.display='block'; return false;">Añadir Inspector</a>

    <div id="nuevo-inspector-form" style="display:none; margin-top: 20px;">
        <form method="post">
            <table class="form-table">
                <tr><th><label>Nombre de Usuario:</label></th><td><input type="text" name="user_login" required></td></tr>
                <tr><th><label>Correo Electrónico:</label></th><td><input type="email" name="user_email" required></td></tr>
                <tr><th><label>CIF asociado:</label></th><td>
                    <select name="user_cif" required>
                        <option value="">Selecciona un CIF</option>
                        <?php foreach ($cifs as $cif): ?>
                            <option value="<?php echo esc_attr($cif); ?>"><?php echo esc_html($cif); ?></option>
                        <?php endforeach; ?>
                    </select>
                </td></tr>
            </table>
            <p><input type="submit" name="crear_inspector" class="button button-primary" value="Crear Inspector"></p>
        </form>
    </div>

    <table class="wp-list-table widefat fixed striped">
        <thead>
            <tr>
                <th>Usuario</th>
                <th>Email</th>
                <th>CIF</th>
                <th>Estado</th>
                <th>Acciones</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($inspectores as $inspector): ?>
                <tr>
                    <td><?php echo esc_html($inspector->user_login); ?></td>
                    <td><?php echo esc_html($inspector->user_email); ?></td>
                    <td><?php echo esc_html($inspector->user_cif); ?></td>
                    <td>
                        <?php
                            $estado = esc_html($inspector->user_estado);
                            $color = ($estado === 'Activado') ? 'green' : 'red';
                            echo "<span style='color:$color;font-weight:bold;'>$estado</span>";
                        ?>
                    </td>
                    <td>
                        <a href="?page=control-horario&tab=inspectores&toggle=<?php echo $inspector->ID; ?>" class="button">
                            <?php echo ($inspector->user_estado === 'Activado') ? 'Desactivar' : 'Activar'; ?>
                        </a>
<a href="?page=control-horario&tab=inspectores&reenviar=<?php echo $inspector->ID; ?>" class="button" title="Reenviar contraseña">🔑</a>
                    </td>
                </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
</div>
