<?php
if (!defined('ABSPATH')) exit;

add_shortcode('consulta-trabajadores', 'consulta_trabajadores_shortcode');

function consulta_trabajadores_shortcode() {
    if (!is_user_logged_in()) {
        return '<p class="pure-alert" style="text-align: center;">No has iniciado sesión.</p>';
    }

    global $wpdb;
    $user_id = get_current_user_id();
    $user = get_userdata($user_id);
    $rol_usuario = $wpdb->get_var($wpdb->prepare(
        "SELECT user_rol FROM {$wpdb->prefix}users WHERE ID = %d AND user_estado = 'Activado'",
        $user_id
    ));

    if (!in_array($rol_usuario, ['Gestor', 'Inspector'])) {
        return '<p class="pure-alert">No tienes permisos para acceder a esta consulta.</p>';
    }

    $cif_registros = $wpdb->get_results($wpdb->prepare(
        "SELECT DISTINCT user_cif 
        FROM {$wpdb->prefix}users 
        WHERE user_email = %s AND user_rol = 'Gestor' AND user_estado = 'Activado'",
        $user->user_email
    ));


    $cifs = array_map(fn($r) => $r->user_cif, $cif_registros);

    if (isset($_POST['seleccionar_cif']) && in_array($_POST['cif'], $cifs)) {
        $_SESSION['cif_activo'] = sanitize_text_field($_POST['cif']);
    }

    $user_cif = $_SESSION['cif_activo'] ?? ($cifs[0] ?? null);

    if (!$user_cif) return '<p class="pure-alert">No se pudo determinar el CIF activo.</p>';

    $trabajadores = $wpdb->get_results($wpdb->prepare(
            "SELECT ID, display_name, user_rol FROM {$wpdb->prefix}users WHERE user_cif = %s AND user_rol IN ('Trabajador', 'Gestor')",
        $user_cif
    ));

    $trabajador_id = isset($_POST['trabajador_id']) ? intval($_POST['trabajador_id']) : '';
    $fecha_inicio = isset($_POST['fecha_inicio']) ? sanitize_text_field($_POST['fecha_inicio']) : '';
    $fecha_fin = isset($_POST['fecha_fin']) ? sanitize_text_field($_POST['fecha_fin']) : '';

    ob_start();
    ?>

    <h3>Consulta de Trabajadores</h3>

    <form method="post" class="pure-form pure-form-stacked">
        <fieldset>
            <div style="display: flex; align-items: center; gap: 10px; flex-wrap: wrap;">
                <div style="display: flex; align-items: center; gap: 5px;">
                    <label for="fecha_inicio">Desde:</label>
                    <input type="date" name="fecha_inicio" id="fecha_inicio" value="<?php echo esc_attr($fecha_inicio); ?>" required>
                </div>
                <div style="display: flex; align-items: center; gap: 5px;">
                    <label for="fecha_fin">Hasta:</label>
                    <input type="date" name="fecha_fin" id="fecha_fin" value="<?php echo esc_attr($fecha_fin); ?>" required>
                </div>
                <?php if (count($cifs) > 1): ?>
                <div style="display: flex; align-items: center; gap: 5px;">
                    <label for="cif">Empresa:</label>
                    <select name="cif" onchange="this.form.submit()">
                        <?php foreach ($cifs as $cif): ?>
                            <option value="<?php echo esc_attr($cif); ?>" <?php selected($cif, $user_cif); ?>>
                                <?php echo esc_html($cif); ?>
                            </option>
                        <?php endforeach; ?>
                    </select>
                    <input type="hidden" name="seleccionar_cif" value="1">
                </div>
                <?php endif; ?>
                <div style="display: flex; align-items: center; gap: 5px;">
                    <label for="trabajador_id">Trabajador:</label>
                    <select name="trabajador_id" id="trabajador_id" required>
                        <option value="">-- Seleccione --</option>
                        <?php foreach ($trabajadores as $trabajador): ?>
                        <?php
                            $sufijo = strtolower($trabajador->user_rol) === 'gestor' ? ' (Gestor)' : '';
                            $mostrar = $trabajador->display_name . $sufijo;
                        ?>
                        <option value="<?php echo esc_attr($trabajador->ID); ?>" <?php selected($trabajador_id, $trabajador->ID); ?>>
                            <?php echo esc_html($mostrar); ?>
                        </option>
                    <?php endforeach; ?>


                    </select>
                </div>
                <button type="submit" class="pure-button pure-button-primary">Consultar</button>
            </div>
        </fieldset>
    </form>

    <?php
    if (!empty($trabajador_id) && !empty($fecha_inicio) && !empty($fecha_fin)) {
        $total_tiempo = $wpdb->get_var($wpdb->prepare(
            "SELECT SEC_TO_TIME(SUM(TIME_TO_SEC(tiempo_total)))
             FROM {$wpdb->prefix}registro_horario 
             WHERE user_id = %d AND DATE(entrada) BETWEEN %s AND %s",
            $trabajador_id, $fecha_inicio, $fecha_fin
        ));

echo "<div style='text-align: center; font-size: 20px; font-weight: bold; margin: 20px 0;'>
        Total de Horas Trabajadas: <span style='font-size: 22px;'>" . ($total_tiempo ?: '00:00:00') . "</span>
      </div>";

        $registros = $wpdb->get_results($wpdb->prepare(
            "SELECT entrada, salida, tiempo_total, latitud_entrada, longitud_entrada, latitud_salida, longitud_salida 
             FROM {$wpdb->prefix}registro_horario
             WHERE user_id = %d AND DATE(entrada) BETWEEN %s AND %s
             ORDER BY entrada ASC",
            $trabajador_id, $fecha_inicio, $fecha_fin
        ));

        echo "<h3>Registros Detallados</h3>";
echo "<table class='pure-table pure-table-bordered' style='width: 100%; text-align: center;'>
        <thead>
            <tr>
                <th>Día</th>
                <th>Entrada</th>
                <th>Salida</th>
                <th>Tiempo</th>
                <th>Total del Día</th>
            </tr>
        </thead>
        <tbody>";

if ($registros) {
    $dias = [];
    foreach ($registros as $r) {
        $fecha = date('Y-m-d', strtotime($r->entrada));
        $dias[$fecha][] = $r;
    }

    $alternar = true;
    foreach ($dias as $fecha => $registros_dia) {
        $total_dia_segundos = 0;
        foreach ($registros_dia as $r) {
            if ($r->tiempo_total) {
                list($h, $m, $s) = explode(':', $r->tiempo_total);
                $total_dia_segundos += ($h * 3600) + ($m * 60) + $s;
            }
        }

        $total_dia = sprintf('%02d:%02d:%02d',
            floor($total_dia_segundos / 3600),
            floor(($total_dia_segundos % 3600) / 60),
            $total_dia_segundos % 60
        );

        $estilo_total_dia = '';
        if ($total_dia_segundos >= 43200) {
            $estilo_total_dia = "style='background-color: #f8d7da; color: red; font-weight: bold;'";
        } elseif ($total_dia_segundos >= 28800) {
            $estilo_total_dia = "style='color: red;'";
        }

        $estilo = $alternar ? 'background-color: #f5f5f5;' : 'background-color: #e0e0e0;';
        $alternar = !$alternar;

        $rowspan = count($registros_dia);
        $primero = true;
        $fecha_formateada = date('d/m/Y', strtotime($fecha));

        foreach ($registros_dia as $r) {
            $entrada = $r->latitud_entrada
                ? "<a href='https://www.google.com/maps?q={$r->latitud_entrada},{$r->longitud_entrada}' target='_blank'>" . date('H:i:s', strtotime($r->entrada)) . "</a>"
                : date('H:i:s', strtotime($r->entrada));

            $salida = $r->salida
                ? ($r->latitud_salida
                    ? "<a href='https://www.google.com/maps?q={$r->latitud_salida},{$r->longitud_salida}' target='_blank'>" . date('H:i:s', strtotime($r->salida)) . "</a>"
                    : date('H:i:s', strtotime($r->salida)))
                : '---';

            $tiempo = $r->tiempo_total ?: '---';

            echo "<tr style='$estilo'>";
            if ($primero) {
                echo "<td rowspan='$rowspan'>$fecha_formateada</td>";
            }
            echo "<td>$entrada</td>
                  <td>$salida</td>
                  <td>$tiempo</td>";
            if ($primero) {
                echo "<td $estilo_total_dia rowspan='$rowspan'>$total_dia</td>";
                $primero = false;
            }
            echo "</tr>";
        }
    }
} else {
    echo "<tr><td colspan='5'>No hay registros en este rango de fechas.</td></tr>";
}

echo "</tbody></table>";


       

        $observaciones = $wpdb->get_results($wpdb->prepare(
            "SELECT fecha_observacion, observaciones 
             FROM {$wpdb->prefix}observaciones
             WHERE user_id = %d AND DATE(fecha_observacion) BETWEEN %s AND %s
             ORDER BY fecha_observacion ASC",
            $trabajador_id, $fecha_inicio, $fecha_fin
        ));

        echo "<h3>Observaciones</h3>
              <table class='pure-table pure-table-bordered'>
              <thead><tr><th>Fecha</th><th>Observación</th></tr></thead><tbody>";

        if ($observaciones) {
            foreach ($observaciones as $obs) {
                echo "<tr><td>" . date('d/m/Y', strtotime($obs->fecha_observacion)) . "</td><td>{$obs->observaciones}</td></tr>";
            }
        } else {
            echo "<tr><td colspan='2'>No hay observaciones.</td></tr>";
        }

        echo "</tbody></table>";
    }

    return ob_get_clean();
}
