<?php
// Evitar acceso directo
if (!defined('ABSPATH')) {
    exit;
}

        // Función para mostrar el formulario de acceso de trabajadores
        function gt_formulario_acceso_trabajadores() {
            if (is_user_logged_in()) {
                $current_user = wp_get_current_user();
                $nombre_usuario = esc_html($current_user->display_name);
                return '<div class="campo-centro gt-acceso-exitoso">
            <p>✅ Has accedido como <strong>' . $nombre_usuario . '</strong></p>
            <div style="text-align: center;">
                <a class="pure-button pure-button-primary" href="' . wp_logout_url(get_permalink()) . '">Cerrar sesión</a>
            </div>
        </div>';


            }

            $output = '';

            // Verificar si hay una cookie con credenciales guardadas
            $saved_user = isset($_COOKIE['remember_user']) ? $_COOKIE['remember_user'] : '';

            if (isset($_POST['gt_login'])) {
            global $wpdb; // Asegúrate de tener esto si no está ya

            $username = sanitize_text_field($_POST['username']);
            $password = sanitize_text_field($_POST['password']);
            $remember = isset($_POST['remember']);

            // Validar el rol del usuario antes de permitir "remember"
            $user = $wpdb->get_row(
                $wpdb->prepare("SELECT user_rol FROM mnkt_users WHERE user_login = %s OR user_email = %s", $username, $username)
            );


            $allowed_roles = ['gestor', 'trabajador'];
                if (!($user && in_array(strtolower($user->user_rol), $allowed_roles))) {
                    $remember = false; // No permitir "recordarme"
                }


            $creds = array(
                'user_login'    => $username,
                'user_password' => $password,
                'remember'      => $remember
            );

            $user = wp_signon($creds, false);

            if (is_wp_error($user)) {
                $output .= '<p class="gt-error">❌ ' . $user->get_error_message() . '</p>';
            } else {
                if ($remember) {
                    setcookie('remember_user', $username, time() + 3600 * 24 * 30, COOKIEPATH, COOKIE_DOMAIN);
                } else {
                    setcookie('remember_user', '', time() - 3600, COOKIEPATH, COOKIE_DOMAIN);
                }
                       if (!defined('DOING_AJAX') || !DOING_AJAX) {
                    // Si el usuario es administrador, lo redirigimos al wp-admin
                    if (in_array('administrator', (array) $user->roles)) {
                        wp_redirect('https://educasede.com/app/wp-admin');
                    } else {
                        wp_redirect(home_url());
                    }
                    exit;
                }

            }
        }


  $output .= '<div class="gt-form-container">
        <h3>Acceso de Trabajadores</h3>
        <form method="post" class="pure-form pure-form-stacked">
            <fieldset>
                <div class="campo-centro">
                     <label for="username">Nombre de usuario:</label>

                    <input type="text" id="username" name="username" value="' . esc_attr($saved_user) . '" required placeholder="Tu usuario...">
                </div>
                <div class="password-container">
                    <div class="campo-centro">
                        <label for="password">Contraseña:</label>

                        <input type="password" id="password" name="password" required placeholder="Tu contraseña...">
                        <a href="#" id="toggle-password" onclick="togglePassword(); return false;">Ver contraseña</a>

                    </div>
                        <div>
                        </div>
                </div>  
                <script>
                function togglePassword() {
                    const passwordInput = document.getElementById("password");
                    const toggleLink = document.getElementById("toggle-password");
                    const isHidden = passwordInput.type === "password";

                    passwordInput.type = isHidden ? "text" : "password";
                    toggleLink.textContent = isHidden ? "Ocultar contraseña" : "Ver contraseña";
                }
                </script>


                <div id="recordarme-container" style="display: none; justify-content: flex-end; align-items: center; gap: 6px; margin-top: 8px;">
                    <input type="checkbox" id="remember" name="remember" style="margin: 0; transform: translateY(1px);">
                    <label for="remember" class="pure-checkbox" style="margin: 0;">Recordarme</label>
                </div>

                

                <a href="' . wp_lostpassword_url() . '" style="display: block; text-align: center; font-size: 12px; margin-top: 5px;">
                    ¿Olvidaste tu contraseña?
                </a>

                <br>

                <div style="text-align: center; margin-top: 10px;">
                    <button type="submit" name="gt_login" class="pure-button pure-button-primary">Iniciar sesión</button>
                </div>
            </fieldset>

            
        </form>
    </div>';

$ajax_url = admin_url("admin-ajax.php"); error_log("AJAX URL: " . $ajax_url);

$output .= '<script>
document.getElementById("username").addEventListener("blur", function () {
    const username = this.value;
    if (!username) return;
    fetch("' . $ajax_url . '?action=check_user_role&username=" + encodeURIComponent(username))
        .then(response => response.json())
        .then(data => {
            const container = document.getElementById("recordarme-container");
            if (data.allowed) {
                container.style.display = "flex";
            } else {
                container.style.display = "none";
            }
        });
});
</script>';


    return $output;
}

// Registrar el shortcode
add_shortcode('acceso_trabajadores', 'gt_formulario_acceso_trabajadores');

// Agregar la hoja de estilos (Pure.css + estilos.css)
function gt_cargar_estilos_acceso() {
    wp_enqueue_style('pure-css', 'https://unpkg.com/purecss@2.0.6/build/pure-min.css', array(), '2.0.6');
    wp_enqueue_style('gt-estilos-personalizados', plugin_dir_url(__FILE__) . 'estilos.css', array('pure-css'), '1.0');
}
add_action('wp_enqueue_scripts', 'gt_cargar_estilos_acceso');


///////////////Para mostrar el recuérdame y que funcione
add_action('wp_ajax_check_user_role', 'gt_verificar_rol_usuario');
add_action('wp_ajax_nopriv_check_user_role', 'gt_verificar_rol_usuario');

function gt_verificar_rol_usuario() {
    global $wpdb;

    $username = sanitize_text_field($_GET['username']);

    $user = $wpdb->get_row(
        $wpdb->prepare("SELECT user_rol FROM mnkt_users WHERE user_login = %s OR user_email = %s", $username, $username)
    );

    $allowed_roles = ['gestor', 'trabajador'];
    $allowed = $user && in_array(strtolower($user->user_rol), $allowed_roles);

    wp_send_json(['allowed' => $allowed]);
}
